% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rThomas_rcpp}
\alias{rThomas_rcpp}
\title{Thomas process individual distribution simulation for one species}
\arguments{
\item{n_points}{The total number of points (individuals).}

\item{n_mother_points}{Number of mother points (= cluster centres).}

\item{xmother}{Vector of \code{n_mother_points} x coordinates for the mother points.}

\item{ymother}{Vector of \code{n_mother_points} y coordinates for the mother points.}

\item{sigma}{Mean displacement (along each coordinate axes) of a point from
its mother point (= cluster centre).}

\item{xmin}{Left limit, \code{default}=0.}

\item{xmax}{Right limit, \code{default}=1.}

\item{ymin}{Bottom limit, \code{default}=0.}

\item{ymax}{Top limit, \code{default}=1.}
}
\value{
A dataframe with x and y coordinates.
}
\description{
Usually used internally inside \code{\link{sim_thomas_coords}}
This function randomly draws points (individuals) around one or several mother points using Rcpp.
The function is an efficient re-implementation of the rThomas function from the spatstat package.
}
\author{
Felix May, Alban Sagouis
}
