% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{MRSSkew}
\alias{MRSSkew}
\title{multivariate skewness of Móri, Rohatgi and Székely}
\usage{
MRSSkew(data)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}
}
\value{
value of sample skewness in the sense of Móri, Rohatgi and Székely.
}
\description{
This function computes the invariant measure of multivariate sample skewness due to Móri, Rohatgi and Székely (1993).
}
\details{
Multivariate sample skewness due to Móri, Rohatgi and Székely (1993) is defined by
\deqn{\widetilde{b}_{n,d}^{(1)}=\frac{1}{n}\sum_{j=1}^n\|Y_{n,j}\|^2\|Y_{n,k}\|^2Y_{n,j}^\top Y_{n,k},}
where \eqn{Y_{n,j}=S_n^{-1/2}(X_j-\overline{X}_n)}, \eqn{\overline{X}_n} is the sample mean and \eqn{S_n} is the sample covariance matrix of the random vectors \eqn{X_1,\ldots,X_n}. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the function returns an error. Note that for \eqn{d=1}, it is equivalent to skewness in the sense of Mardia.
}
\references{
Móri, T. F., Rohatgi, V. K., Székely, G. J. (1993), On multivariate skewness and kurtosis, Theory of Probability and its Applications, 38:547–551.

Henze, N. (2002), Invariant tests for multivariate normality: a critical review, Statistical Papers, 43:467–506.
}
