% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Paket_alle_Funktionen_Basis_v01_1-9Juli2018.R
\name{mmmgee}
\alias{mmmgee}
\title{Covariance Matrix Estimation for Multiple Marginal GEE Models}
\usage{
mmmgee(x, biascorr = FALSE)
}
\arguments{
\item{x}{a list of \code{geem} objects fitted with \code{geem2}. The \code{geem} objects must be different models calculated with data from the same subjects.
In particular, the parameter \code{id} in the call to \code{geem2} must refer to the same subjects in each model.}

\item{biascorr}{logical, if \code{TRUE}, a bias corrected covariance matrix is calculate by extending the
method due to Mancl and DeRouen to multiple models. See references.}
}
\value{
A list with class \code{mmmgee} containing the following components:
\describe{
\item{\code{beta}}{The stacked vector of regression coefficient estimates from the models in \code{x}.}
\item{\code{V}}{The estimated covariance matrix of the regression coefficient estimates.}
\item{\code{A}}{The outer component of \eqn{V=ABA}.}
\item{\code{B}}{The inner component of \eqn{V=ABA}.}
\item{\code{biascorr}}{The value of the input argument \code{biascorr} (logical).}
\item{\code{n}}{A vector with the number of clusters in each model in \code{x}.}
\item{\code{p}}{A vector with number of regression coefficients in each model in \code{x}.}
}
}
\description{
Calculate the covariance matrix for a stacked vector of regression coefficients 
from multiple marginal GEE models fitted with \code{\link{geem2}}.
}
\examples{
data(lesions)
m1<-geem2(clearance~trt,id=id,data=lesions,family=binomial,corstr="independence")
m2<-geem2(pain~trt,id=id,data=lesions[lesions$lesion==1,],family=gaussian,corstr="independence")
mmmgee(x=list(m1,m2),biascorr=TRUE)

}
\references{
Lloyd A. Mancl, Timothy A. DeRouen. A covariance estimator for GEE with improved small sample properties. Biometrics, 2001, 57(1):126-134.
}
\seealso{
\code{\link{geem2}}, \code{\link{mmmgee.test}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}
}
