% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citationModule.R
\name{citationServer}
\alias{citationServer}
\title{Server Function for Citation Module}
\usage{
citationServer(id, citations)
}
\arguments{
\item{id}{A character string that matches the ID used in \code{citationUI}.}

\item{citations}{A named list of citations. Each element can be:
\itemize{
\item A character string containing a formatted citation.
\item A function that returns a formatted citation string.
\item A citation object that can be passed to \code{format_citation}.
}}
}
\value{
A Shiny module server function.
}
\description{
This function defines the server logic for the citation module.
}
\examples{
citations <- list(
  "Example Citation" = "Author, A. (Year). Title. Journal, Vol(Issue), pages.",
  "R Citation" = function() format_citation(utils::citation())
)
server <- function(input, output, session) {
  citationServer("my_citations", citations)
}

}
