% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackAsyncTuning.R
\name{callback_async_tuning}
\alias{callback_async_tuning}
\title{Create Asynchronous Tuning Callback}
\usage{
callback_async_tuning(
  id,
  label = NA_character_,
  man = NA_character_,
  on_optimizer_queue_before_eval = NULL,
  on_optimization_begin = NULL,
  on_worker_begin = NULL,
  on_optimizer_before_eval = NULL,
  on_eval_after_xs = NULL,
  on_resample_begin = NULL,
  on_resample_before_train = NULL,
  on_resample_before_predict = NULL,
  on_resample_end = NULL,
  on_eval_after_resample = NULL,
  on_eval_before_archive = NULL,
  on_optimizer_after_eval = NULL,
  on_optimizer_queue_after_eval = NULL,
  on_worker_end = NULL,
  on_tuning_result_begin = NULL,
  on_result_begin = NULL,
  on_result_end = NULL,
  on_result = NULL,
  on_optimization_end = NULL
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{label}{(\code{character(1)})\cr
Label for the new instance.}

\item{man}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}

\item{on_optimizer_queue_before_eval}{(\verb{function()})\cr
Stage called before the optimizer queue is evaluated.
Called in \code{OptimInstance$.eval_queue()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_optimization_begin}{(\verb{function()})\cr
Stage called at the beginning of the optimization.
Called in \code{Optimizer$optimize()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_worker_begin}{(\verb{function()})\cr
Stage called at the beginning of the optimization on the worker.
Called in the worker loop.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_optimizer_before_eval}{(\verb{function()})\cr
Stage called after the optimizer proposes points.
Called in \code{OptimInstance$.eval_point()}.
The functions must have two arguments named \code{callback} and \code{context}.
The argument of \code{instance$.eval_point(xs)} and \code{xs_trafoed} and \code{extra} are available in the \code{context}.
Or \code{xs} and \code{xs_trafoed} of \code{instance$.eval_queue()} are available in the \code{context}.}

\item{on_eval_after_xs}{(\verb{function()})\cr
Stage called after xs is passed to the objective.
Called in \code{ObjectiveTuningAsync$eval()}.
The functions must have two arguments named \code{callback} and \code{context}.
The argument of \verb{$.eval(xs)} is available in the \code{context}.}

\item{on_resample_begin}{(\verb{function()})\cr
Stage called at the beginning of a resampling iteration.
Called in \code{workhorse()} (internal).
See also \code{\link[mlr3:callback_resample]{mlr3::callback_resample()}}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_resample_before_train}{(\verb{function()})\cr
Stage called before training the learner.
Called in \code{workhorse()} (internal).
See also \code{\link[mlr3:callback_resample]{mlr3::callback_resample()}}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_resample_before_predict}{(\verb{function()})\cr
Stage called before predicting.
Called in \code{workhorse()} (internal).
See also \code{\link[mlr3:callback_resample]{mlr3::callback_resample()}}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_resample_end}{(\verb{function()})\cr
Stage called at the end of a resampling iteration.
Called in \code{workhorse()} (internal).
See also \code{\link[mlr3:callback_resample]{mlr3::callback_resample()}}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_eval_after_resample}{(\verb{function()})\cr
Stage called after a hyperparameter configuration is evaluated.
Called in \code{ObjectiveTuningAsync$eval()}.
The functions must have two arguments named \code{callback} and \code{context}.
The \code{resample_result} is available in the `context}

\item{on_eval_before_archive}{(\verb{function()})\cr
Stage called before performance values are written to the archive.
Called in \code{ObjectiveTuningAsync$eval()}.
The functions must have two arguments named \code{callback} and \code{context}.
The \code{aggregated_performance} is available in \code{context}.}

\item{on_optimizer_after_eval}{(\verb{function()})\cr
Stage called after points are evaluated.
Called in \code{OptimInstance$.eval_point()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_optimizer_queue_after_eval}{(\verb{function()})\cr
Stage called after the optimizer queue is evaluated.
Called in \code{OptimInstance$.eval_queue()}.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_worker_end}{(\verb{function()})\cr
Stage called at the end of the optimization on the worker.
Called in the worker loop.
The functions must have two arguments named \code{callback} and \code{context}.}

\item{on_tuning_result_begin}{(\verb{function()})\cr
Stage called at the beginning of the result writing.
Called in \verb{TuningInstance*$assign_result()}.
The functions must have two arguments named \code{callback} and \code{context}.
The arguments of \verb{$assign_result(xdt, y, learner_param_vals, extra)} are available in \code{context}.}

\item{on_result_begin}{(\verb{function()})\cr
Stage called at the beginning of the result writing.
Called in \code{OptimInstance$assign_result()}.
The functions must have two arguments named \code{callback} and \code{context}.
The arguments of \verb{$.assign_result(xdt, y, extra)} are available in the \code{context}.}

\item{on_result_end}{(\verb{function()})\cr
Stage called after the result is written.
Called in \code{OptimInstance$assign_result()}.
The functions must have two arguments named \code{callback} and \code{context}.
The final result \code{instance$result} is available in the \code{context}.}

\item{on_result}{(\verb{function()})\cr
Deprecated.
Use \code{on_result_end} instead.
Stage called after the result is written.
Called in \code{OptimInstance$assign_result()}.}

\item{on_optimization_end}{(\verb{function()})\cr
Stage called at the end of the optimization.
Called in \code{Optimizer$optimize()}.}
}
\description{
Function to create a \link{CallbackAsyncTuning}.
Predefined callbacks are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_callbacks} and can be retrieved with \code{\link[=clbk]{clbk()}}.

Tuning callbacks can be called from different stages of the tuning process.
The stages are prefixed with \verb{on_*}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Start Tuning
     - on_optimization_begin
    Start Worker
         - on_worker_begin
         Start Optimization on Worker
           - on_optimizer_before_eval / on_optimizer_queue_before_eval
             Start Evaluation
               - on_eval_after_xs
                 Start Resampling Iteration
                   - on_resample_begin
                   - on_resample_before_train
                   - on_resample_before_predict
                   - on_resample_end
                 End Resampling Iteration
               - on_eval_after_resample
               - on_eval_before_archive
             End Evaluation
          - on_optimizer_after_eval / on_optimizer_queue_after_eval
         End Optimization on Worker
         - on_worker_end
    End Worker
     - on_tuning_result_begin
     - on_result_begin
     - on_result_end
     - on_optimization_end
End Tuning
}\if{html}{\out{</div>}}

See also the section on parameters for more information on the stages.
A tuning callback works with \link{ContextAsyncTuning}.
}
\details{
When implementing a callback, each function must have two arguments named \code{callback} and \code{context}.
A callback can write data to the state (\verb{$state}), e.g. settings that affect the callback itself.
Tuning callbacks access \link{ContextAsyncTuning} and \link[mlr3:ContextResample]{mlr3::ContextResample}.
}
