% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerTorchModule.R
\name{mlr_learners.module}
\alias{mlr_learners.module}
\alias{LearnerTorchModule}
\title{Learner Torch Module}
\description{
Create a torch learner from a torch module.
}
\section{Dictionary}{

This \link[mlr3:Learner]{Learner} can be instantiated using the sugar function \code{\link[mlr3:mlr_sugar]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{lrn("classif.module", ...)
lrn("regr.module", ...)
}\if{html}{\out{</div>}}
}

\section{Properties}{

\itemize{
\item Supported task types: 'classif', 'regr'
\item Predict Types:
\itemize{
\item classif: 'response', 'prob'
\item regr: 'response'
}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, \dQuote{character}, \dQuote{factor}, \dQuote{ordered}, \dQuote{POSIXct}, \dQuote{Date}, \dQuote{lazy_tensor}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3torch}, \CRANpkg{torch}
}
}

\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
nn_one_layer = nn_module("nn_one_layer",
  initialize = function(task, size_hidden) {
    self$first = nn_linear(task$n_features, size_hidden)
    self$second = nn_linear(size_hidden, output_dim_for(task))
  },
  # argument x corresponds to the ingress token x
  forward = function(x) {
    x = self$first(x)
    x = nnf_relu(x)
    self$second(x)
  }
)
learner = lrn("classif.module",
  module_generator = nn_one_layer,
  ingress_tokens = list(x = ingress_num()),
  epochs = 10,
  size_hidden = 20,
  batch_size = 16
)
task = tsk("iris")
learner$train(task)
learner$network
\dontshow{\}) # examplesIf}
}
\seealso{
Other Learner: 
\code{\link{mlr_learners.ft_transformer}},
\code{\link{mlr_learners.mlp}},
\code{\link{mlr_learners.tab_resnet}},
\code{\link{mlr_learners.torch_featureless}},
\code{\link{mlr_learners_torch}},
\code{\link{mlr_learners_torch_image}},
\code{\link{mlr_learners_torch_model}}

Other Learner: 
\code{\link{mlr_learners.ft_transformer}},
\code{\link{mlr_learners.mlp}},
\code{\link{mlr_learners.tab_resnet}},
\code{\link{mlr_learners.torch_featureless}},
\code{\link{mlr_learners_torch}},
\code{\link{mlr_learners_torch_image}},
\code{\link{mlr_learners_torch_model}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3torch:LearnerTorch]{mlr3torch::LearnerTorch}} -> \code{LearnerTorchModule}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerTorchModule-new}{\code{LearnerTorchModule$new()}}
\item \href{#method-LearnerTorchModule-clone}{\code{LearnerTorchModule$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="configure"><a href='../../mlr3/html/Learner.html#method-Learner-configure'><code>mlr3::Learner$configure()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="encapsulate"><a href='../../mlr3/html/Learner.html#method-Learner-encapsulate'><code>mlr3::Learner$encapsulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="selected_features"><a href='../../mlr3/html/Learner.html#method-Learner-selected_features'><code>mlr3::Learner$selected_features()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="LearnerTorch" data-id="dataset"><a href='../../mlr3torch/html/LearnerTorch.html#method-LearnerTorch-dataset'><code>mlr3torch::LearnerTorch$dataset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="LearnerTorch" data-id="format"><a href='../../mlr3torch/html/LearnerTorch.html#method-LearnerTorch-format'><code>mlr3torch::LearnerTorch$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="LearnerTorch" data-id="marshal"><a href='../../mlr3torch/html/LearnerTorch.html#method-LearnerTorch-marshal'><code>mlr3torch::LearnerTorch$marshal()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="LearnerTorch" data-id="print"><a href='../../mlr3torch/html/LearnerTorch.html#method-LearnerTorch-print'><code>mlr3torch::LearnerTorch$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="LearnerTorch" data-id="unmarshal"><a href='../../mlr3torch/html/LearnerTorch.html#method-LearnerTorch-unmarshal'><code>mlr3torch::LearnerTorch$unmarshal()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerTorchModule-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerTorchModule-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerTorchModule$new(
  module_generator = NULL,
  param_set = NULL,
  ingress_tokens = NULL,
  task_type,
  properties = NULL,
  optimizer = NULL,
  loss = NULL,
  callbacks = list(),
  packages = character(0),
  feature_types = NULL,
  predict_types = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{module_generator}}{(\code{function} or \code{nn_module_generator})\cr
A \code{nn_module_generator} or \code{function} returning an \code{nn_module}.
Both must take as argument the \code{task} for which to construct the network.
Other arguments to its initialize method can be provided as parameters.}

\item{\code{param_set}}{(\code{NULL} or \code{\link[paradox:ParamSet]{ParamSet}})\cr
If provided, contains the parameters for the module_generator.
If \code{NULL}, parameters will be inferred from the module_generator.}

\item{\code{ingress_tokens}}{(\code{list} of \code{\link[=TorchIngressToken]{TorchIngressToken()}})\cr
A list with ingress tokens that defines how the dataset will be defined.
The names must correspond to the arguments of the network's forward method.
For numeric, categorical, and lazy tensor features, you can use \code{\link[=ingress_num]{ingress_num()}},
\code{\link[=ingress_categ]{ingress_categ()}}, and \code{\link[=ingress_ltnsr]{ingress_ltnsr()}} to create them.}

\item{\code{task_type}}{(\code{character(1)})\cr
The task type, either \verb{"classif}" or \code{"regr"}.}

\item{\code{task_type}}{(\code{character(1)})\cr
The task type.}

\item{\code{properties}}{(\code{NULL} or \code{character()})\cr
The properties of the learner.
Defaults to all available properties for the given task type.}

\item{\code{optimizer}}{(\code{\link{TorchOptimizer}})\cr
The optimizer to use for training.
Per default, \emph{adam} is used.}

\item{\code{loss}}{(\code{\link{TorchLoss}})\cr
The loss used to train the network.
Per default, \emph{mse} is used for regression and \emph{cross_entropy} for classification.}

\item{\code{callbacks}}{(\code{list()} of \code{\link{TorchCallback}}s)\cr
The callbacks. Must have unique ids.}

\item{\code{packages}}{(\code{character()})\cr
The R packages this object depends on.}

\item{\code{feature_types}}{(\code{NULL} or \code{character()})\cr
The feature types. Defaults to all available feature types.}

\item{\code{predict_types}}{(\code{character()})\cr
The predict types.
See \code{\link[mlr3:mlr_reflections]{mlr_reflections$learner_predict_types}} for available values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerTorchModule-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerTorchModule-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerTorchModule$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
