% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTrafo.R
\name{mlr_pipeops_targetinvert}
\alias{mlr_pipeops_targetinvert}
\alias{PipeOpTargetInvert}
\title{PipeOpTargetInvert}
\format{
\code{\link{R6Class}} object inheriting from \code{\link{PipeOp}}.
}
\description{
Inverts target-transformations done during training based on a supplied inversion
function. Typically should be used in combination with a subclass of \code{\link{PipeOpTargetTrafo}}.

During prediction phase the function supplied through \code{"fun"} is called with a \code{list} containing
the \code{"prediction"} as a single element, and should return a \code{list} with a single element
(a \code{\link[mlr3:Prediction]{Prediction}}) that is returned by \code{\link{PipeOpTargetInvert}}.
}
\section{Construction}{
\preformatted{PipeOpTargetInvert$new(id = "targetinvert", param_vals = list())
}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"targetinvert"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

\code{\link{PipeOpTargetInvert}} has two input channels named \code{"fun"} and \code{"prediction"}. During
training, both take \code{NULL} as input. During prediction, \code{"fun"} takes a function and
\code{"prediction"} takes a \code{\link[mlr3:Prediction]{Prediction}}.

\code{\link{PipeOpTargetInvert}} has one output channel named \code{"output"} and returns \code{NULL} during
training and a \code{\link[mlr3:Prediction]{Prediction}} during prediction.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

\code{\link{PipeOpTargetInvert}} has no parameters.
}

\section{Internals}{

Should be used in combination with a subclass of \code{\link{PipeOpTargetTrafo}}.
}

\section{Fields}{

Only fields inherited from \code{\link{PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOp}}.
}

\seealso{
Other PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpProxy}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_yeojohnson}},
\code{\link{mlr_pipeops}}
}
\concept{PipeOps}
