% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpClassBalancing.R
\docType{data}
\name{mlr_pipeops_classbalancing}
\alias{mlr_pipeops_classbalancing}
\alias{PipeOpClassBalancing}
\title{PipeOpClassBalancing}
\format{\code{\link{R6Class}} object inheriting from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.}
\description{
Both undersamples a \code{\link[mlr3:Task]{Task}} to keep only a fraction of the rows of the majority class,
as well as oversamples (repeats data points) rows of the minority class.

Sampling happens only during training phase. Class-balancing a \code{\link[mlr3:Task]{Task}} by sampling may be
beneficial for classification with imbalanced training data.
}
\section{Construction}{
\preformatted{PipeOpClassBalancing$new(id = "classbalancing", param_vals = list())
}
\itemize{
\item \code{id} :: \code{character(1)}
Identifier of the resulting  object, default \code{"classbalancing"}
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpTaskPreproc}}. Instead of a \code{\link[mlr3:Task]{Task}}, a
\code{\link[mlr3:TaskClassif]{TaskClassif}} is used as input and output during training and prediction.

The output during training is the input \code{\link[mlr3:Task]{Task}} with added or removed rows to balance target classes.
The output during prediction is the unchanged input.
}

\section{State}{

The \code{$state} is a named \code{list} with the \code{$state} elements inherited from \code{\link{PipeOpTaskPreproc}}.
}

\section{Parameters}{

The parameters are the parameters inherited from \code{\link{PipeOpTaskPreproc}}; however, the \code{affect_columns} parameter is \emph{not} present. Further parameters are:
\itemize{
\item \code{ratio} :: \code{numeric(1)} \cr
Ratio of number of rows of classes to keep, relative
to the \code{$reference} value. Initialized to 1.
\item \code{reference} :: \code{numeric(1)} \cr
What the \code{$ratio} value is measured against. Can be \code{"all"} (mean instance count of
all classes), \code{"major"} (instance count of class with most instances), \code{"minor"}
(instance count of class with fewest instances), \code{"nonmajor"} (average instance
count of all classes except the major one), \code{"nonminor"} (average instance count
of all classes except the minor one), and \code{"one"} (\code{$ratio} determines the number of
instances to have, per class). Initialized to \code{"all"}.
\item \code{adjust} :: \code{numeric(1)} \cr
Which classes to up / downsample. Can be \code{"all"} (up and downsample all to match required
instance count), \code{"major"}, \code{"minor"}, \code{"nonmajor"}, \code{"nonminor"} (see respective values
for \code{$reference}), \code{"upsample"} (only upsample), and \code{"downsample"}. Initialized to \code{"all"}.
\item \code{shuffle} :: \code{logical(1)} \cr
Whether to shuffle the result. Otherwise, the resulting task will have the original items that
were not removed in downsampling in-order, followed by all newly sampled items ordered by target class.
Initialized to \code{TRUE}.
}
}

\section{Internals}{

Up / downsampling happens as follows: At first, a "target class count" is calculated, by taking the mean
class count of all classes indicated by the \code{reference} parameter (e.g. if \code{reference} is \code{"nonmajor"}:
the mean class count of all classes that are not the "major" class, i.e. the class with the most samples)
and multiplying this with the value of the \code{ratio} parameter. If \code{reference} is \code{"one"}, then the "target
class count" is just the value of \code{ratio} (i.e. \code{1 * ratio}).

Then for each class that is referenced by the \code{adjust} parameter (e.g. if \code{adjust} is \code{"nonminor"}:
each class that is not the class with the fewest samples), \code{\link{PipeOpClassBalancing}} either throws out
samples (downsampling), or adds additional rows that are equal to randomly chosen samples (upsampling),
until the number of samples for these classes equals the "target class count".

Uses \code{task$filter()} to remove rows. When identical rows are added during upsampling, then the \code{task$row_roles$use} can \emph{not} be used
to duplicate rows because of [inaudible]; instead the \code{task$rbind()} function is used, and
a new \code{\link{data.table}} is attached that contains all rows that are being duplicated exactly as many times as they are being added.
}

\section{Fields}{

Only fields inherited from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\examples{
library("mlr3")

task = tsk("spam")
opb = po("classbalancing")

# target class counts
table(task$truth())

# double the instances in the minority class (spam)
opb$param_set$values = list(ratio = 2, reference = "minor",
  adjust = "minor", shuffle = FALSE)
result = opb$train(list(task))[[1L]]
table(result$truth())

# up or downsample all classes until exactly 20 per class remain
opb$param_set$values = list(ratio = 20, reference = "one",
  adjust = "all", shuffle = FALSE)
result = opb$train(list(task))[[1]]
table(result$truth())
}
\seealso{
Other PipeOps: \code{\link{PipeOpEnsemble}},
  \code{\link{PipeOpImpute}},
  \code{\link{PipeOpTaskPreproc}}, \code{\link{PipeOp}},
  \code{\link{mlr_pipeops_boxcox}},
  \code{\link{mlr_pipeops_branch}},
  \code{\link{mlr_pipeops_chunk}},
  \code{\link{mlr_pipeops_classifavg}},
  \code{\link{mlr_pipeops_classweights}},
  \code{\link{mlr_pipeops_colapply}},
  \code{\link{mlr_pipeops_collapsefactors}},
  \code{\link{mlr_pipeops_copy}},
  \code{\link{mlr_pipeops_encodeimpact}},
  \code{\link{mlr_pipeops_encodelmer}},
  \code{\link{mlr_pipeops_encode}},
  \code{\link{mlr_pipeops_featureunion}},
  \code{\link{mlr_pipeops_filter}},
  \code{\link{mlr_pipeops_fixfactors}},
  \code{\link{mlr_pipeops_histbin}},
  \code{\link{mlr_pipeops_ica}},
  \code{\link{mlr_pipeops_imputehist}},
  \code{\link{mlr_pipeops_imputemean}},
  \code{\link{mlr_pipeops_imputemedian}},
  \code{\link{mlr_pipeops_imputenewlvl}},
  \code{\link{mlr_pipeops_imputesample}},
  \code{\link{mlr_pipeops_kernelpca}},
  \code{\link{mlr_pipeops_learner}},
  \code{\link{mlr_pipeops_missind}},
  \code{\link{mlr_pipeops_modelmatrix}},
  \code{\link{mlr_pipeops_mutate}},
  \code{\link{mlr_pipeops_nop}},
  \code{\link{mlr_pipeops_pca}},
  \code{\link{mlr_pipeops_quantilebin}},
  \code{\link{mlr_pipeops_regravg}},
  \code{\link{mlr_pipeops_removeconstants}},
  \code{\link{mlr_pipeops_scalemaxabs}},
  \code{\link{mlr_pipeops_scalerange}},
  \code{\link{mlr_pipeops_scale}},
  \code{\link{mlr_pipeops_select}},
  \code{\link{mlr_pipeops_smote}},
  \code{\link{mlr_pipeops_spatialsign}},
  \code{\link{mlr_pipeops_subsample}},
  \code{\link{mlr_pipeops_unbranch}},
  \code{\link{mlr_pipeops_yeojohnson}},
  \code{\link{mlr_pipeops}}
}
\concept{PipeOps}
\keyword{datasets}
