% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_private.R
\name{get_private<-}
\alias{get_private<-}
\title{Assign Value to Private Field}
\usage{
get_private(x, which) <- value
}
\arguments{
\item{x}{(any)\cr
Object whose private field should be modified.}

\item{which}{(character(1))\cr
Private field that is being modified.}

\item{value}{(any)\cr
Value to assign to the private field.}
}
\value{
The R6 instance x, modified in-place. If it is not an R6 instance, NULL is returned.
}
\description{
Convenience function to assign a value to a private field of an \link[R6:R6Class]{R6::R6Class} instance.
}
\examples{
library(R6)
item = R6Class("Item", private = list(x = 1))$new()
get_private(item)$x
get_private(item, "x") = 2L
get_private(item)$x
}
