% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureClassifConfusion.R
\docType{data}
\name{MeasureClassifConfusion}
\alias{MeasureClassifConfusion}
\alias{mlr_measures_classif.confusion}
\alias{mlr_measures_classif.tp}
\alias{mlr_measures_classif.fn}
\alias{mlr_measures_classif.fp}
\alias{mlr_measures_classif.tn}
\alias{mlr_measures_classif.tpr}
\alias{mlr_measures_classif.fnr}
\alias{mlr_measures_classif.fpr}
\alias{mlr_measures_classif.tnr}
\alias{mlr_measures_classif.ppv}
\alias{mlr_measures_classif.fdr}
\alias{mlr_measures_classif.for}
\alias{mlr_measures_classif.npv}
\alias{mlr_measures_classif.precision}
\alias{mlr_measures_classif.recall}
\alias{mlr_measures_classif.sensitivity}
\alias{mlr_measures_classif.specificity}
\title{Binary Classification Measures Derived from a Confusion Matrix}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{MeasureClassif}.}
\description{
All implemented \link{Measure}s call \code{\link[=confusion_measures]{confusion_measures()}} with the respective \code{type} internally.
}
\section{Construction}{
\preformatted{MeasureClassifConfusion$new(id = type, type)

mlr_measures("classif.tp")
mlr_measures("classif.fn")
mlr_measures("classif.fp")
mlr_measures("classif.tn")
mlr_measures("classif.tpr")
mlr_measures("classif.fnr")
mlr_measures("classif.fpr")
mlr_measures("classif.tnr")
mlr_measures("classif.ppv")
mlr_measures("classif.fdr")
mlr_measures("classif.for")
mlr_measures("classif.npv")
mlr_measures("classif.precision")
mlr_measures("classif.recall")
mlr_measures("classif.sensitivity")
mlr_measures("classif.specificity")

msr("classif.tp")
msr("classif.fn")
msr("classif.fp")
msr("classif.tn")
msr("classif.tpr")
msr("classif.fnr")
msr("classif.fpr")
msr("classif.tnr")
msr("classif.ppv")
msr("classif.fdr")
msr("classif.for")
msr("classif.npv")
msr("classif.precision")
msr("classif.recall")
msr("classif.sensitivity")
msr("classif.specificity")
}
\itemize{
\item \code{type} :: \code{character(1)}\cr
See \code{\link[=confusion_measures]{confusion_measures()}}.
}
}

\examples{
task = tsk("german_credit")
learner = lrn("classif.rpart")
p = learner$train(task)$predict(task)
measures = list(msr("classif.sensitivity"), msr("classif.specificity"))
round(p$score(measures), 2)
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Measure]{Measures}: \link{mlr_measures}
}
\keyword{datasets}
