% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generatePartialPrediction.R
\name{plotPartialPrediction}
\alias{plotPartialPrediction}
\title{Plot a partial prediction with ggplot2.}
\usage{
plotPartialPrediction(obj, geom = "line", facet = NULL, p = 1)
}
\arguments{
\item{obj}{[\code{PartialPredictionData}]\cr
Generated by \code{\link{generatePartialPredictionData}}.}

\item{geom}{[\code{charater(1)}]\cr
The type of geom to use to display the data. Can be \dQuote{line} or \dQuote{tile}.
For tiling at least two features must be used with \code{interaction = TRUE} in the call to
\code{\link{generatePartialPredictionData}}. This may be used in conjuction with the
\code{facet} argument if three features are specified in the call to
\code{\link{generatePartialPredictionData}}.
Default is \dQuote{line}.}

\item{facet}{[\code{character(1)}]\cr
The name of a feature to be used for facetting.
This feature must have been an element of the \code{features} argument to
\code{\link{generatePartialPredictionData}} and is only applicable when said argument had length
greater than 1.
If \code{\link{generatePartialPredictionData}} is called with the \code{interaction} argument \code{FALSE}
(the default) with argument \code{features} of length greater than one, then \code{facet} is ignored and
each feature is plotted in its own facet.
Note that if any of the elements of the \code{features} argument of \code{\link{generatePartialPredictionData}}
are factors, they will be coerced to numerics.
Default is \code{NULL}.}

\item{p}{[\code{numeric(1)}]\cr
If \code{individual = TRUE} then \code{sample} allows the user to sample without replacement
from the output to make the display more readable. Each row is sampled with probability \code{p}.
Default is \code{1}.}
}
\value{
ggplot2 plot object.
}
\description{
Plot a partial prediction from \code{\link{generatePartialPredictionData}} using ggplot2.
}
\seealso{
Other partial_prediction: \code{\link{generatePartialPredictionData}},
  \code{\link{plotPartialPredictionGGVIS}}

Other plot: \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotFilterValues}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialPredictionGGVIS}},
  \code{\link{plotROCCurves}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}
}

