% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateThreshVsPerf.R
\name{plotROCCurves}
\alias{plotROCCurves}
\title{Plots a ROC curve using ggplot2}
\usage{
plotROCCurves(obj, measures = obj$measures[1:2], diagonal = TRUE,
  pretty.names = TRUE)
}
\arguments{
\item{obj}{[(list of) \code{\link{Prediction}} | (list of) \code{\link{ResampleResult}} | \code{\link{BenchmarkResult}}]\cr
Single prediction object, list of them, single resample result, list of them, or a benchmark result.
In case of a list probably produced by different learners you want to compare, then
name the list with the names you want to see in the plots, probably
learner shortnames or ids.}

\item{measures}{[\code{\link{Measure}} | list of \code{\link{Measure}}]\cr
Performance measure(s) to evaluate.
Default is the default measure for the task, see here \code{\link{getDefaultMeasure}}.}

\item{diagonal}{[\code{logical(1)}]\cr
Whether to plot a dashed diagonal line.
Default is \code{FALSE}.}

\item{pretty.names}{[\code{logical(1)}]\cr
Whether to use the \code{\link{Measure}} name instead of the id in the plot.
Default is \code{TRUE}.}
}
\value{
a ggvis plot object.
}
\description{
Plots a ROC curve from predictions.
}
\examples{
\donttest{
lrn = makeLearner("classif.rpart", predict.type = "prob")
fit = train(lrn, sonar.task)
pred = predict(fit, task = sonar.task)
roc = generateThreshVsPerfData(pred, list(fpr, tpr))
plotROCCurves(roc)

r = bootstrapB632plus(lrn, sonar.task, iters = 3)
roc_r = generateThreshVsPerfData(r, list(fpr, tpr), aggregate = FALSE)
plotROCCurves(roc_r)

r2 = crossval(lrn, sonar.task, iters = 3)
roc_l = generateThreshVsPerfData(list(boot = r, cv = r2), list(fpr, tpr), aggregate = FALSE)
plotROCCurves(roc_l)
}
}
\seealso{
Other plot: \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotFilterValues}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialPredictionGGVIS}},
  \code{\link{plotPartialPrediction}},
  \code{\link{plotROCRCurvesGGVIS}},
  \code{\link{plotROCRCurves}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}

Other thresh_vs_perf: \code{\link{generateThreshVsPerfData}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}
}

