% Generated by roxygen2 (4.0.2): do not edit by hand
\name{makeLearner}
\alias{Learner}
\alias{makeLearner}
\title{Create learner object.}
\usage{
makeLearner(cl, id = cl, predict.type = "response", fix.factors = FALSE,
  ..., par.vals = list(), config = list())
}
\arguments{
\item{cl}{[\code{character(1)}]\cr
Class of learner. By convention, all classification learners
start with \dQuote{classif.}, all regression learners with
\dQuote{regr.}, all survival learners start with \dQuote{surv.}
and all clustering learners with \dQuote{cluster.}.
A list of all learners is available on the
\code{\link{learners}} help page.}

\item{id}{[\code{character(1)}]\cr
Id string for object. Used to display object.
Default is \code{cl}.}

\item{predict.type}{[\code{character(1)}]\cr
Classification: \dQuote{response} (= labels) or \dQuote{prob} (= probabilities and labels by selecting the ones with maximal probability).
Regression: \dQuote{response} (= mean response) or \dQuote{se} (= standard errors and mean response).
Survival: \dQuote{response} (= some sort of orderable risk) or \dQuote{prob} (= time dependent probabilities).
Clustering: \dQuote{response} (= cluster IDS) or \dQuote{prob} (= fuzzy cluster membership probabilities).
Default is \dQuote{response}.}

\item{fix.factors}{[\code{logical(1)}]\cr
In some cases, problems occur in underlying learners for factor features during prediction.
If the new features have LESS factor levels than during training (a strict subset),
the learner might produce an  error like
\dQuote{type of predictors in new data do not match that of the training data}.
In this case one can repair this problem by setting this option to \code{TRUE}.
We will simply add the missing factor levels missing from the test feature
(but present in training) to that feature.
Default is \code{FALSE}.}

\item{...}{[any]\cr
Optional named (hyper)parameters.
Alternatively these can be given using the \code{par.vals} argument.}

\item{par.vals}{[\code{list}]\cr
Optional list of named (hyper)parameters. The arguments in
\code{...} take precedence over values in this list. We strongly
encourage you to use one or the other to pass (hyper)parameters
to the learner but not both.}

\item{config}{[\code{named list}]\cr
Named list of config option to overwrite global settings set via \code{\link{configureMlr}}
for this specific learner.}
}
\value{
[\code{\link{Learner}}].
}
\description{
For a classification learner the \code{predict.type} can be set
to \dQuote{prob} to predict probabilities and the maximum
value selects the label. The threshold used to assign the label can later be changed using the
\code{\link{setThreshold}} function.
}
\examples{
makeLearner("classif.rpart")
makeLearner("classif.lda", predict.type = "prob")
lrn = makeLearner("classif.lda", method = "t", nu = 10)
print(lrn$par.vals)
}
\seealso{
[\code{\link{resample}}], [\code{\link{predict.WrappedModel}}]
}

