% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CostSensWeightedPairsWrapper.R
\name{makeCostSensWeightedPairsWrapper}
\alias{makeCostSensWeightedPairsWrapper}
\alias{CostSensWeightedPairsWrapper}
\alias{CostSensWeightedPairsModel}
\title{Wraps a classifier for cost-sensitive learning to produce a weighted pairs model.}
\usage{
makeCostSensWeightedPairsWrapper(learner)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The classification learner.
If you pass a string the learner will be created via \link{makeLearner}.}
}
\value{
(\link{Learner}).
}
\description{
Creates a wrapper, which can be used like any other learner object.
Models can easily be accessed via \link{getLearnerModel}.

For each pair of labels, we fit a binary classifier.
For each observation we define the label to be the element of the pair with minimal costs.
During fitting, we also weight the observation with the absolute difference in costs.
Prediction is performed by simple voting.

This approach is sometimes called cost-sensitive one-vs-one (CS-OVO),
because it is obviously very similar to the
one-vs-one approach where one reduces a normal multi-class problem to
multiple binary ones and aggregates by voting.
}
\references{
Lin, HT.:
Reduction from Cost-sensitive Multiclass Classification to
One-versus-one Binary Classification.
In: Proceedings of the Sixth Asian Conference on Machine Learning.
JMLR Workshop and Conference Proceedings, vol 39, pp. 371-386. JMLR W&CP (2014).
\url{http://www.jmlr.org/proceedings/papers/v39/lin14.pdf}
}
\seealso{
Other costsens: \code{\link{makeCostSensClassifWrapper}},
  \code{\link{makeCostSensRegrWrapper}},
  \code{\link{makeCostSensTask}}
}
\concept{costsens}
