% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICCm.R
\name{ICCm}
\alias{ICCm}
\title{Computes ICC values for mixed-effects models}
\usage{
ICCm(model, re_type = c("NA"))
}
\arguments{
\item{model}{A linear mixed-effects model of class lmerMod or lmerModLmerTest}

\item{re_type}{A value indicating whether a model with two random effects is nested or cross-classified}
}
\value{
If \code{re_type} is "NA", the proportion of variance at the random effect is computed.

If re_type = "nested", the likeness of y scores in the same level 3 unit (the proportion of variance at Level3_factor), the likeness of y scores in the same level 2 units in the same level 3 unit (proportion of variance at Level3_factor and Level2_factor), and the likeness of level 2 units in the same level 3 unit (proportion of Level2_factor variance at Level3_factor) are computed.

If re_type = "cc", the likeness of y scores in the same C1_factor unit (correlation between outcome values of units in same C1_factor but different C2_factor), the likeness of y scores in the same C2_factor (correlation between outcome values of units in the same C2_factor but different C2_factor), and the likeness of y scores in the same C1_factor and C2_factor combination (correlation between outcome values of units in the same C2_factor and C2_factor) are computed.
}
\description{
Computes ICC values for lme4-fitted mixed-effects models.
}
\examples{
# Read in data
data(instruction)
# Create model
mod <- lme4::lmer(mathgain ~ (1 | classid), data = instruction)
# Estimate ICC
ICCm(mod)

}
\references{
Snijders, T. A. B. & Bosker, R. J. (2012). Multilevel Analysis (2nd Ed.). Sage Publications Ltd.
}
