% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlim.mids.R
\name{mlim.mids}
\alias{mlim.mids}
\title{prepare "mids" class object}
\usage{
mlim.mids(mlim, incomplete)
}
\arguments{
\item{mlim}{array of class "mlim", returned by "mlim" function}

\item{incomplete}{the original data.frame with NAs}
}
\value{
object of class 'mids', as required by 'mice' package for analyzing
        multiple imputation data
}
\description{
takes "mlim" object and prepares a "mids" class for data analysis with
             multiple imputation.
}
\examples{

\donttest{
data(iris)
require(mice)
irisNA <- mlim.na(iris, p = 0.1, seed = 2022)

# adding unstratified NAs to all variables of a data.frame
MLIM <- mlim(irisNA, m=5, tuning_time = 180, doublecheck = T, seed = 2022)

# create the mids object for MICE package
mids <- mlim.mids(MLIM, irisNA)

# run an analysis on the mids data (just as example)
fit <- with(data=mids, exp=glm(Species~ Sepal.Length, family = "binomial"))

# then, pool the results!
summary(pool(fit))
}
}
\author{
E. F. Haghish, based on code from 'prelim' frunction in missMDA R package
}
