% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-registry.R
\name{mlflow_search_registered_models}
\alias{mlflow_search_registered_models}
\title{List registered models}
\usage{
mlflow_search_registered_models(
  filter = NULL,
  max_results = 100,
  order_by = list(),
  page_token = NULL,
  client = NULL
)
}
\arguments{
\item{filter}{A filter expression used to identify specific registered models.
The syntax is a subset of SQL which allows only ANDing together binary operations.
Example: "name = 'my_model_name' and tag.key = 'value1'"}

\item{max_results}{Maximum number of registered models to retrieve.}

\item{order_by}{List of registered model properties to order by. Example: "name".}

\item{page_token}{Pagination token to go to the next page based on a
previous query.}

\item{client}{(Optional) An MLflow client object returned from \link[mlflow]{mlflow_client}.
If specified, MLflow will use the tracking server associated with the passed-in client. If
unspecified (the common case),
MLflow will use the tracking server associated with the current tracking URI.}
}
\description{
Retrieves a list of registered models.
}
