% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.R
\name{perm}
\alias{perm}
\title{Permutation Test}
\usage{
perm(x, y, func, reps)
}
\arguments{
\item{x, y}{numeric vectors of data values}

\item{func}{specify \code{mlf} function: (\code{distcorr} or \code{mic}).}

\item{reps}{(optional) number of resamples. Defaults to 500.}
}
\description{
Provides nonparametric statistical significance via sample randomization.
}
\examples{
# Sample data
a <- rnorm(25, 80, 35)
b <- rnorm(25, 100, 50)

mlf::mic(a, b)
mlf::perm(a, b, mic)
}
