% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.saem.mmkin.R
\name{anova.saem.mmkin}
\alias{anova.saem.mmkin}
\title{Anova method for saem.mmkin objects}
\usage{
\method{anova}{saem.mmkin}(
  object,
  ...,
  method = c("is", "lin", "gq"),
  test = FALSE,
  model.names = NULL
)
}
\arguments{
\item{object}{An \link{saem.mmkin} object}

\item{...}{further such objects}

\item{method}{Method for likelihood calculation: "is" (importance sampling),
"lin" (linear approximation), or "gq" (Gaussian quadrature). Passed
to \link[saemix:logLik]{saemix::logLik.SaemixObject}}

\item{test}{Should a likelihood ratio test be performed? If TRUE,
the alternative models are tested against the first model. Should
only be done for nested models.}

\item{model.names}{Optional character vector of model names}
}
\value{
an "anova" data frame; the traditional (S3) result of anova()
}
\description{
Generate an anova object. The method to calculate the BIC is that from the
saemix package. As in other prominent anova methods, models are sorted by
number of parameters, and the tests (if requested) are always relative to
the model on the previous line.
}
