% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mmkin.R
\name{summary.mmkin}
\alias{summary.mmkin}
\alias{print.summary.mmkin}
\title{Summary method for class "mmkin"}
\usage{
\method{summary}{mmkin}(object, conf.level = 0.95, ...)

\method{print}{summary.mmkin}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{an object of class \link{mmkin}}

\item{conf.level}{confidence level for testing parameters}

\item{\dots}{optional arguments passed to methods like \code{print}.}

\item{x}{an object of class \code{summary.mmkin}.}

\item{digits}{number of digits to use for printing}
}
\description{
Shows status information on the \link{mkinfit} objects contained in the object
and gives an overview of ill-defined parameters calculated by \link{illparms}.
}
\examples{

fits <- mmkin(
  c("SFO", "FOMC"),
  list("FOCUS A" = FOCUS_2006_A,
       "FOCUS C" = FOCUS_2006_C),
  quiet = TRUE, cores = 1)
  summary(fits)

}
