% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setExtEncounter.R
\name{setExtEncounter}
\alias{setExtEncounter}
\alias{getExtEncounter}
\alias{ext_encounter}
\alias{ext_encounter<-}
\title{Set external encounter rate}
\usage{
setExtEncounter(params, ext_encounter = NULL, ...)

getExtEncounter(params)

ext_encounter(params)

ext_encounter(params) <- value
}
\arguments{
\item{params}{MizerParams}

\item{ext_encounter}{Optional. An array (species x size) holding the external
encounter rate.  If not supplied, a default of 0 is used.}

\item{...}{Unused}

\item{value}{ext_encounter}
}
\value{
\code{setExtEncounter()}: A MizerParams object with updated external encounter
rate.

\code{getExtEncounter()} or equivalently \code{ext_encounter()}: An array
(species x size) with the external encounter rate.
}
\description{
Set external encounter rate
}
\section{Setting external encounter rate}{

The external encounter rate is the rate at which a predator encounters
food that is not explicitly modelled. It is a rate with units mass/year.

The \code{ext_encounter} argument allows you to specify an external encounter rate
that depends on species and body size. You can see an example of this in
the Examples section of the help page for \code{\link[=setExtEncounter]{setExtEncounter()}}.
}

\examples{
params <- newMultispeciesParams(NS_species_params)

#### Setting allometric encounter rate #######################

# Set coefficient for each species. Here we choose 0.1 for each species
encounter_pre <- rep(0.1, nrow(species_params(params)))

# Multiply by power of size with exponent, here chosen to be 3/4
# The outer() function makes it an array species x size
allo_encounter <- outer(encounter_pre, w(params)^(3/4))

# Change the external encounter rate in the params object
ext_encounter(params) <- allo_encounter
}
\seealso{
Other functions for setting parameters: 
\code{\link{gear_params}()},
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setMetabolicRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
