% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{NS_species_params_gears}
\alias{NS_species_params_gears}
\title{Example species parameter set based on the North Sea with different gears}
\format{
A data frame with 12 rows and 8 columns. Each row is a species.
\describe{
\item{species}{Name of the species}
\item{w_max}{The size at which the population invests 100\% of its income into
reproduction so that all growth stops.}
\item{w_mat}{Size at maturity}
\item{beta}{Size preference ratio}
\item{sigma}{Width of the size-preference}
\item{R_max}{Maximum reproduction rate}
\item{k_vb}{The von Bertalanffy k parameter}
\item{w_inf}{The von Bertalanffy asymptotic size}
\item{gear}{Name of the fishing gear}
}
}
\source{
{Blanchard et al.}
}
\usage{
NS_species_params_gears
}
\description{
This data set is based on species in the North Sea (Blanchard et al.).
It is similar to the data set \code{NS_species_params} except that
this one has an additional column specifying the fishing gear that
operates on each species.
}
\examples{
params <- MizerParams(NS_species_params_gears)
}
\keyword{datasets}
