% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{getDiet}
\alias{getDiet}
\title{Get diet of predator at size, resolved by prey species}
\usage{
getDiet(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  proportion = TRUE
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{proportion}{If TRUE (default) the function returns the diet as a
proportion of the total consumption rate. If FALSE it returns the
consumption rate in grams.}
}
\value{
An array (predator species  x predator size x
(prey species + resource + other components) )
}
\description{
Calculates the rate at which a predator of a particular species and size
consumes biomass of each prey species and resource.
}
\details{
This function performs the same integration as
\code{\link[=getEncounter]{getEncounter()}} but does not aggregate over prey species, and
multiplies by (1-feeding_level) to get the consumed biomass rather than the
available biomass. Outside the range of sizes for a predator species the
returned rate is zero.
}
\seealso{
Other summary functions: 
\code{\link{getBiomass}()},
\code{\link{getGrowthCurves}()},
\code{\link{getN}()},
\code{\link{getSSB}()},
\code{\link{getYieldGear}()},
\code{\link{getYield}()}
}
\concept{summary functions}
\concept{summary_function}
