% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bic_calculator.R
\name{computeBIC}
\alias{computeBIC}
\title{Compute the approximate BIC}
\usage{
computeBIC(model)
}
\arguments{
\item{model}{the \code{mixedMemModel} object for which the BIC will be calculated.}
}
\value{
\code{computeBIC} returns the approximate BIC value, a real number.
}
\description{
\code{computeBIC} computes the approximate BIC of a given \code{mixedMemModel}, where the lower bound on the log-likelihood
(also called ELBO) is used instead of the intractable true log-likelihood.
}
\details{
\eqn{BIC = -2 ELBO + p \log(Total)}

where p is the number of estimated parameters and Total is the number of individuals in
the sample.

This BIC model selection criteria is used in Erosheva et al (2007). The number of estimated parameters P includes the
parameters \eqn{\theta} and \eqn{\alpha}, but omits the variational parameters \eqn{\phi} and \eqn{\delta}.
}
\references{
Erosheva, E. A., Fienberg, S. E., & Joutard, C. (2007). Describing disability through individual-level mixture models for multivariate binary data. The annals of applied statistics, 1(2), 346.
}

