% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlleleFreq.R
\name{AlleleFreq}
\alias{AlleleFreq}
\title{Calculate Allele Frequency}
\usage{
AlleleFreq(x,sep)
}
\arguments{
\item{x}{a dataset of genotypes. Each row denotes each individual; each column contain each marker.}

\item{sep}{the allele separator in the imported genotype data.Note: when using the special character like "|", remember to protect it as "\\|"(default).}
}
\value{
a matrix of allele frequencies. Each row denotes each allele; each column denotes each marker. The order of makers follows x.
}
\description{
Calculate Allele Frequency
}
\details{
This function calculates the allele frequencies of one dataset.
}
\examples{
require(mixIndependR)
x <- data.frame(STR1=c("12|12","13|14","13|13","14|15"),
               SNP1=c("A|A","T|T","A|T","A|T"))
AlleleFreq(x,"\\\\|")

}
