% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_Mix_utils.R
\name{plot.Mix}
\alias{plot.Mix}
\title{\code{plot} Method for \code{\link{Mix}} Objects}
\usage{
\method{plot}{Mix}(
  x,
  ylim,
  xlim = NULL,
  xout = NULL,
  n = 511,
  type = NULL,
  xlab = "x",
  ylab = "f(x)",
  main = attr(obj, "name"),
  lwd = 1.4,
  log = FALSE,
  components = TRUE,
  h0 = FALSE,
  parComp = list(col = NULL, lty = 3, lwd = 1),
  parH0 = list(col = NULL, lty = 3, lwd = 1),
  ...
)
}
\arguments{
\item{x}{object of class \code{Mix}.}

\item{ylim}{range of y values to use, if not specified (or containing \code{NA}), the function tries to construct reasonable default values.}

\item{xlim}{range of x values to use, particularly important if \code{xout} is not specified. If not specified, the function tries to construct reasonable default values.}

\item{xout}{numeric or \code{NULL} giving the abscissae at which to draw the density.}

\item{n}{number of points to generate if \code{xout} is unspecified (for continuous distributions).}

\item{type}{character denoting the type of plot, see e.g. \code{\link[graphics]{lines}}. Defaults to \code{"l"} if the mixture distribution is continuous and to \code{"h"} if discrete.}

\item{xlab, ylab}{labels for the x and y axis with defaults.}

\item{main}{main title of plot, defaulting to the \code{\link{Mix}} object name.}

\item{lwd}{line width for plotting, a positive number.}

\item{log}{logical flag, if \code{TRUE}, probabilities/densities \eqn{f} are plotted as \eqn{log(f)}. Only works if \code{components} is set to \code{FALSE}.}

\item{components}{logical flag indicating whether the individual mixture components should be plotted, set to \code{TRUE} by default.}

\item{h0}{logical flag indicating whether the line \eqn{y = 0} should be drawn.}

\item{parComp}{graphical parameters for drawing the individual components if \code{components} is set to \code{TRUE}.}

\item{parH0}{graphical parameters for drawing the line \eqn{y = 0} if \code{h0} is set to \code{TRUE}.}

\item{\dots}{further arguments passed to the function for plotting the mixture density.}
}
\description{
\code{plot} method for \code{\link{Mix}} objects visualizing the mixture density, with an option of showing the component densities.
}
\examples{

# define 'Mix' object
normLocMix <- Mix("norm", discrete = FALSE, w = c(0.3, 0.4, 0.3), mean = c(10, 13, 17),
                  sd = c(1, 1, 1))
poisMix <- Mix("pois", discrete = TRUE, w = c(0.45, 0.45, 0.1), lambda = c(1, 5, 10))

# plot 'Mix' object
plot(normLocMix)
plot(poisMix)

}
\seealso{
\code{\link{Mix}} for the construction of \code{Mix} objects, \code{\link{dMix}} for the density/mass of a mixture.
}
\keyword{cluster}
