% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.sav.R
\name{read.sav}
\alias{read.sav}
\title{Read SPSS File}
\usage{
read.sav(file, use.value.labels = FALSE, use.missings = TRUE, formats = FALSE,
         label = TRUE, labels = TRUE, missing = FALSE, widths = FALSE,
         as.data.frame = TRUE, check = TRUE)
}
\arguments{
\item{file}{a character string indicating the name of the SPSS data file
with or without file extension '.sav', e.g., \code{"My_SPSS_Data.sav"}
or \code{"My_SPSS_Data"}.}

\item{use.value.labels}{logical: if \code{TRUE}, variables with value labels are converted into factors.}

\item{use.missings}{logical: if \code{TRUE} (default), user-defined missing values are converted into NAs.}

\item{formats}{logical: if \code{TRUE}, variable formats are shown in an attribute for all variables.}

\item{label}{logical: if \code{TRUE} (default), variable labels are shown in an attribute for all variables.}

\item{labels}{logical: if \code{TRUE} (default), value labels are shown in an attribute for all variables.}

\item{missing}{logical: if \code{TRUE}, value labels for user-defined missings are shown in an attribute.
for all variables.}

\item{widths}{logical: if \code{TRUE}, widths are shown in an attribute for all variables.}

\item{as.data.frame}{logical: if \code{TRUE} (default), function returns a regular data frame (default);
if \code{FALSE} function returns a tibble.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a data frame or tibble.
}
\description{
This function calls the \code{read_spss} function in the \pkg{haven} package
by Hadley Wickham and Evan Miller (2019) to read an SPSS file.
}
\examples{
\dontrun{
# Read SPSS data
read.sav("SPSS_Data.sav")
read.sav("SPSS_Data")

# Read SPSS data, convert variables with value labels into factors
read.sav("SPSS_Data.sav", use.value.labels = TRUE)

# Read SPSS data, user-defined missing values are not converted into NAs
read.sav("SPSS_Data.sav", use.missing = FALSE)

# Read SPSS data as tibble
read.sav("SPSS_Data.sav", as.data.frame = FALSE)
}
}
\references{
Hadley Wickham and Evan Miller (2019). \emph{haven: Import and Export 'SPSS', 'Stata' and 'SAS' Files}.
R package version 2.1.1.\url{https://CRAN.R-project.org/package=haven}
}
\seealso{
\code{\link{write.sav}}, \code{\link{read.xlsx}}, \code{\link{read.mplus}}
}
\author{
Hadley Wickham and Evan Miller
}
