% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R
\name{freq}
\alias{freq}
\title{Frequency Tables}
\usage{
freq(x, print = c("no", "all", "perc", "v.perc"), freq = TRUE, split = FALSE,
     labels = TRUE, val.col = FALSE, exclude = 15, digits = 2, as.na = NULL,
     check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a vector, factor, matrix or data frame.}

\item{print}{a character string indicating which percentage(s) to be printed on the console, i.e.,
no percentages (\code{"no"}), all percentages (\code{"all"}), percentage frequencies
(\code{"print"}), and valid percentage frequencies (\code{"v.perc"}).
Default setting when specifying one variable in \code{x} is \code{print = "all"}, while
default setting when specifying more than one variable in \code{x} is \code{print = "no"}
unless \code{split = TRUE}.}

\item{freq}{logical: if \code{TRUE} (default), absolute frequencies will be shown on the console.}

\item{split}{logical: if \code{TRUE}, output table is split by variables when specifying more than one
variable in \code{x}.}

\item{labels}{logical: if \code{TRUE} (default), labels for the factor levels will be used.}

\item{val.col}{logical: if \code{TRUE}, values are shown in the columns, variables in the rows.}

\item{exclude}{an integer value indicating the maximum number of unique values for variables to be
included in the analysis when specifying more than one variable in \code{x}, i.e.,
variables with the number of unique values exceeding \code{exclude} will be excluded
from the analysis.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying
percentages.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}
}
\value{
Returns an object of class \code{freq}, which is a list with following entries: function call (\code{call}),
matrix or data frame specified in \code{x} (\code{data}), specification of function arguments (\code{args}), and
list with results (\code{result}).
}
\description{
This function computes frequency tables with absolute and percentage frequencies for one or more than one variable.
}
\details{
By default, the function displays the absolute and percentage frequencies when specifying one variable in the
argument \code{x}, while the function displays only the absolute frequencies when more than one variable is specified.
The function displays valid percentage frequencies only in the presence of missing values and excludes variables
with all values missing from the analysis. Note that it is  possible to mix numeric variables, factors, and character
variables in the data frame specified in the argument \code{x}.
}
\examples{
dat <- data.frame(x1 = c(3, 3, 2, 3, 2, 3, 3, 2, 1, -99),
                  x2 = c(2, 2, 1, 3, 1, 1, 3, 3, 2, 2),
                  y1 = c(1, 4, NA, 5, 2, 4, 3, 5, NA, 1),
                  y2 = c(2, 3, 4, 3, NA, 4, 2, 3, 4, 5),
                  z = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10))

# Frequency table for one variable
freq(dat$x1)

# Frequency table for one variable,
# values shown in columns
freq(dat$x1, val.col = TRUE)

# Frequency table for one variable,
# convert value -99 into NA
freq(dat$x1, as.na = -99)

# Frequency table for one variable
# use 3 digit for displaying percentages
freq(dat$x1, digits = 3)

# Frequency table for more than one variable
freq(dat[, c("x1", "x2", "y1", "y2")])

# Frequency table for more than one variable,
# values shown in columns
freq(dat[, c("x1", "x2", "y1", "y2")], val.col = TRUE)

# Frequency table for more than one variable,
# with percentage frequencies
freq(dat[, c("x1", "x2", "y1", "y2")], print = "all")

# Frequency table for more than one variable,
# with percentage frequencies, values shown in columns
freq(dat[, c("x1", "x2", "y1", "y2")], print = "all", val.col = TRUE)

# Frequency table for more than one variable,
# split output table
freq(dat[, c("x1", "x2", "y1", "y2")], split = TRUE)

# Frequency table for more than one variable,
# exclude variables with more than 5 unique values
freq(dat, exclude = 5)

# Frequency table for a factor
freq(factor(c("a", "a", "b", "c", "b")))

# Frequency table for one variable,
# do not use labels of the factor levels
freq(factor(c("a", "a", "b", "c", "b")), labels = FALSE)
}
\references{
Becker, R. A., Chambers, J. M., & Wilks, A. R. (1988). \emph{The New S Language}. Wadsworth & Brooks/Cole.
}
\seealso{
\code{\link{crosstab}}, \code{\link{descript}}, \code{\link{multilevel.descript}},
\code{\link{na.descript}}.
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
