% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMP.R
\name{BMP}
\alias{BMP}
\title{Bayesian Moving Particles}
\usage{
BMP(
  dimension,
  lsf,
  q,
  N = 1000,
  N.final = N,
  N.iter = 30,
  adaptive = FALSE,
  N.DoE = 5 * dimension,
  firstDoE = "uniform",
  radius = qnorm(1e-10, lower.tail = FALSE),
  X,
  y,
  covariance = NULL,
  learn_each_train = Inf,
  km.param = list(nugget.estim = TRUE, multistart = 1, optim.method = "BFGS", coef.trend
    = q),
  burnin = 20,
  fast = TRUE,
  sur = list(integrated = TRUE, r = 1, approx.pnorm = FALSE),
  lower.tail = TRUE,
  save.dir,
  plot = FALSE,
  plot.lsf = TRUE,
  plot.lab = c("x_1", "x_2"),
  chi2 = FALSE,
  verbose = 1,
  breaks
)
}
\arguments{
\item{dimension}{the dimension of the input space.}

\item{lsf}{the function defining the RV of interest Y = lsf(X).}

\item{q}{a given quantile to estimate the corresponding probability.}

\item{N}{the total number of Poisson processes during the refinement step.}

\item{N.final}{the total number of Poisson processes for the final alpha estimate.}

\item{N.iter}{the total number of iteration of the algorithm, ie that total number of
calls to the \code{lsf} will be \code{N.DoE + N.iter*r}.}

\item{adaptive}{if the algorithm should stop automatically if the stopping criterion
is verified, precisely the mean probability of misclassification of the particles
being over a given threshold.}

\item{N.DoE}{the number of points for the initial Design of Experiment}

\item{firstDoE}{default is "uniform" for a random
uniform sampling over a sphere of radius \code{radius}. Also available "maximim" for a maximim LHS.}

\item{radius}{the size of the radius of the sphere for uniform DoE or the semi length
of the interval on each dimension for maximin LHS}

\item{X}{(optional) a first Design of Experiemnt to be used instead of building
a new DoE}

\item{y}{the value of \code{lsf} on the \code{X}}

\item{covariance}{(optional) to give a covariance kernel for the \code{km} object.}

\item{learn_each_train}{a integer: after this limit the covariance parameters are not
learnt any more and model is just updated with the new datapoints.}

\item{km.param}{(optional) list of parameters to be passed to \code{DiceKriging::km}.}

\item{burnin}{a burnin parameter for Markov Chain drawing of the metamodel based
Poisson process (this does not change the number of calls to \code{lsf}).}

\item{fast}{in current implementation it appears that the call to the metamodel is
faster when doing batch computation. This parameter lets do the Markov chain the other way
around: instead of first selecting a starting point and then applying \code{burnin} times the
transition kernel, it creates a working population by apply the kernel to all the
particles and then makes some moves with the generated discretised distribution.}

\item{sur}{a list containing any parameters to be passed to \code{estimateSUR}. Default is
\code{sur$integrated=TRUE} and \code{sur$r=1} for a one step ahead integrated SUR criterion.}

\item{lower.tail}{as for pxxxx functions, TRUE for estimating P(lsf(X) < q), FALSE
for P(lsf(X) > q).}

\item{save.dir}{(optional) a directory to save the \code{X} and \code{y} at each iteration.}

\item{plot}{to plot the DoE and the updated model.}

\item{plot.lsf}{to plot the contour of the true \code{lsf}. Note that this requires its
evaluation on a grid and should be used only on toy examples.}

\item{plot.lab}{the labels of the axis for the plot.}

\item{chi2}{for a chi2 test on the number of events.}

\item{verbose}{controls the level of outputs of the algorithm.}

\item{breaks}{optional, for the final histogram if \code{chi2 == TRUE}.}
}
\value{
An object of class \code{list} containing the outputs described below:
\item{alpha}{the estimated conditional expectation of the probability.}
\item{alpha.seq}{the sequence of estimated alpha during the refinement step.}
\item{cv2}{an estimate of the squarred coefficient of variation of alpha.}
\item{cv.seq}{the sequence of the estimated coefficients of variations.}
\item{h}{the sequence of the estimated upper bound of the conditional variance
divided by estimated alpha.}
\item{I}{the sequence of the estimated integrated h.}
\item{sur_min}{a list containing the the sequence of corresponding thresholds and
-log probability of the sample minimising the SUR criterion.}
\item{sur_stat}{a list containing at each iterations number of points tried for the SUR
criterion as well as the computational spent.}
\item{q}{the reference quantile for the probability estimate.}
\item{ecdf}{the empirical cdf, i.e. the estimation of the function q -> E(alpha(q)).}
\item{L_max}{the farthest state reached by the random process. Validity range
for the \code{ecdf} is then (-Inf, L_max] or [L_max, Inf).}
\item{PPP}{the last Poisson process generated with \code{N.final} particles.}
\item{meta_fun}{the metamodel approximation of the \code{lsf}. A call output is a
list containing the value and the standard deviation.}
\item{model}{the final metamodel. An S4 object from \pkg{DiceKriging}. Note
that the algorithm enforces the problem to be the estimation of P[lsf(X)>q]
and so using \sQuote{predict} with this object will return inverse values if
\code{lower.tail==TRUE}; in this scope prefer using directly \code{meta_fun} which
handles this possible issue.}
\item{model.first}{the first metamodel with the intial DoE.}
\item{alpha_int}{a 95\% confidence intervalle on the estimate of alpha.}
\item{moves}{a vector containing the number of moves for each one of the \code{N.batch} particles.}
\item{chi2}{the output of the chisq.test function.}
}
\description{
This function runs the Bayesian Moving Particles algorithm for estimating extreme probability
and quantile.
}
\details{
The Bayesian Moving Particles algorithm uses the point process framework for rare event to iteratively estimate
the conditional expectation of the (random) limit-state function, to quantify the quality of the learning
and to propose a new point to be added to the model with a SUR criterion.
}
\note{
Probleme should be defined in the standard space. Transformations can be made using \code{UtoX} and \code{XtoU}
functions.
}
\examples{
# Estimate P(g(X)<0)
\dontrun{p <- BMP(dimension = 2, lsf = kiureghian, q = 0, N = 100, N.iter = 30, plot = TRUE)}

# More extreme event
\dontrun{p <- BMP(dimension = 2, lsf = waarts, q = -4, N = 100, N.iter = 50, plot = TRUE)}

# One can also estimate probability of the form P(g(X)>q)
\dontrun{p <- BMP(dimension = 2, lsf = cantilever, q = 1/325, N = 100, N.iter = 30, plot = TRUE)}

}
\references{
\itemize{
   \item A. Guyader, N. Hengartner and E. Matzner-Lober:\cr
    \emph{Simulation and estimation of extreme quantiles and extreme
    probabilities}\cr
    Applied Mathematics \& Optimization, 64(2), 171-196.\cr
   \item C. Walter:\cr
   \emph{Moving Particles: a parallel optimal Multilevel Splitting
   method with application in quantiles estimation and meta-model
   based algorithms}\cr
   Structural Safety, 55, 10-25.\cr
   \item J. Bect, L. Li and E. Vazquez:\cr
   \emph{Bayesian subset simulation}\cr
   arXiv preprint arXiv:1601.02557
 }
}
\seealso{
\code{\link{SubsetSimulation}}
\code{\link{MonteCarlo}}
\code{\link{IRW}}
\code{\link{MP}}
}
\author{
Clement WALTER \email{clementwalter@icloud.com}
}
