% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_risk.R
\name{risk}
\alias{risk}
\alias{risk.PNP}
\alias{risk.GNG}
\title{Risk Measures of Fitted Objects}
\usage{
risk(model, alpha, expectile = TRUE, plot = FALSE, ggplot = FALSE,
  text_ylim = -0.15, size = 1)

\method{risk}{PNP}(model, alpha = 0.05, expectile = TRUE,
  plot = FALSE, ggplot = FALSE, text_ylim = -0.15, size = 1)

\method{risk}{GNG}(model, alpha = 0.05, expectile = TRUE,
  plot = FALSE, ggplot = FALSE, text_ylim = -0.15, size = 1)
}
\arguments{
\item{model}{output object of \code{GNG_fit()} or \code{PNP_fit()}.}

\item{alpha}{levels of risk measures.}

\item{expectile}{logical, if also expectiles should be computed, default: TRUE.}

\item{plot}{plot the results?, default: FALSE.}

\item{ggplot}{plot the results with ggplot2?, default: FALSE.}

\item{text_ylim}{y coordinate for annotation in ggplot2, default: -0.15.}

\item{size}{size of the text indicating the risk measures in the plot, default: 1.}
}
\value{
List of class risk_measures.
}
\description{
\code{risk} computes the VaR, ES and expectiles at a given level for fitted distribution.
}
\details{
VaR are computed using the \code{q()} call of the fitted distribution.

         ES is computed directly (i.e. the integrals are precomputed, not numerically)
         as an integral of the quantile function.

         Expectiles can be obtained as a unit-root solution of the identity between quantiles
         and expectiles. These are equivalent for corresponding \eqn{\tau} and \eqn{\alpha}
         if \deqn{\tau=(\alpha q(\alpha) -G(\alpha))/(\mu - 2G(\alpha)-(1-2\alpha)q(\alpha))} where \eqn{\mu}
         is mean, \eqn{q()} is the quantile function and \eqn{G(\alpha) =\int_{-\infty}^{q(\alpha)} y dF(y)}.
}
\examples{
\dontrun{
 GNG <- GNG_fit(stocks$SAP)
 PNP <- PNP_fit(stocks$MSFT)

 risk(PNP, alpha = c(0.01,0.05,0.08,0.1))
 risk(GNG, alpha = c(0.01,0.05,0.08,0.1), plot = TRUE)
}
}
