% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{autoplot.dist}
\alias{autoplot.dist}
\title{Autoplot of Distributions Using ggplot2}
\usage{
\method{autoplot}{dist}(x, which = "all", cols = 2, ...)
}
\arguments{
\item{x}{distribution object.}

\item{which}{whether to plot only CDF, PDF or both, default: 'all'.}

\item{cols}{in how many columns should the plots be merged, default: 2.}

\item{...}{further arguments to be passed.}
}
\value{
ggplot object if which = "cdf" or which = "pdf". If both are plotted, the plots are
        merged using \code{multiplot()} function and a list with both plots is invisibly returned.
}
\description{
The function \code{autoplot} plots the CDF and PDF of a given distribution object.
}
\details{
The function is a wrapper of the internal plotting function plotgg. For more 
details see \code{\link{plotgg}}.
}
\examples{
\dontrun{
N <- normdist()
autoplot(N)

# manipulating cdf plot
B <- binomdist(12, 0.5)
autoplot(-3*B, which = "cdf", xlim1 = c(-30, -10))
# manipulating pdf plot
autoplot(-3*B, which = "pdf", xlim2 = c(-30, -10))
}
}
\seealso{
\code{\link{plotgg}}
}
