% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr_new.R
\name{Burr}
\alias{Burr}
\alias{dburr}
\alias{pburr}
\alias{qburr}
\alias{rburr}
\title{The Burr Distribution}
\usage{
dburr(x, shape1, shape2, log = FALSE)

pburr(q, shape1, shape2, lower.tail = TRUE, log.p = FALSE)

qburr(p, shape1, shape2, lower.tail = TRUE, log.p = FALSE)

rburr(n, shape1, shape2)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{shape1}{shape parameter.}

\item{shape2}{shape parameter.}

\item{log, log.p}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}, default: FALSE.}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}, default: TRUE.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dburr} gives the density, \code{pburr} gives the distribution function, \code{qburr} gives the quantile function,
         and \code{rburr} generates random deviates.

         Invalid arguments will result in return value NaN, with a warning.
}
\description{
Density, distribution function, quantile function and random generation for the Burr distribution with parameters
shape1 and shape2.
}
\details{
The Burr distribution function with shape1 parameter c and shape2 parameter k has density given by
         \deqn{f(x)=ckx^(c-1)/(1+x^c)^(k+1)} for \eqn{x>0}. The cumulative distribution function is
         \deqn{F(x)=1-(1+x^c)^-k} on \eqn{x>0}.

         See \url{https://en.wikipedia.org/wiki/Burr_distribution} for more details.
}
\examples{
dburr(seq(1, 5), 2, 2)
qburr(pburr(seq(1, 5), 2, 2), 2 ,2)
rburr(5, 2, 2)
}
\seealso{
\code{\link{burrdist}}
}
