% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals.R
\name{gintervals.neighbors}
\alias{gintervals.neighbors}
\title{Finds neighbors between two sets of intervals}
\usage{
gintervals.neighbors(
  intervals1 = NULL,
  intervals2 = NULL,
  maxneighbors = 1,
  mindist = -1e+09,
  maxdist = 1e+09,
  mindist1 = -1e+09,
  maxdist1 = 1e+09,
  mindist2 = -1e+09,
  maxdist2 = 1e+09,
  na.if.notfound = FALSE,
  intervals.set.out = NULL
)
}
\arguments{
\item{intervals1, intervals2}{intervals}

\item{maxneighbors}{maximal number of neighbors}

\item{mindist, maxdist}{distance range for 1D intervals}

\item{mindist1, maxdist1, mindist2, maxdist2}{distance range for 2D intervals}

\item{na.if.notfound}{if 'TRUE' return 'NA' interval if no matching
neighbors were found, otherwise omit the interval in the answer}

\item{intervals.set.out}{intervals set name where the function result is
optionally outputted}
}
\value{
If 'intervals.set.out' is 'NULL' a data frame containing the pairs
of intervals from 'intervals1', intervals from 'intervals2' and an
additional column named 'dist' ('dist1' and 'dist2' for 2D intervals)
representing the distance between the corresponding intervals. The intervals
from intervals2 would be changed to 'chrom1', 'start1', and 'end1' and for
2D intervals chrom11, start11, end11 and chrom22, start22, end22. If
'na.if.notfound' is 'TRUE', the data frame contains all the intervals from
'intervals1' including those for which no matching neighbor was found. For
the latter intervals an 'NA' neighboring interval is stated. If
'na.if.notfound' is 'FALSE', the data frame contains only intervals from
'intervals1' for which matching neighbor(s) was found.
}
\description{
Finds neighbors between two sets of intervals.
}
\details{
This function finds for each interval in 'intervals1' the closest
'maxneighbors' intervals from 'intervals2'.

For 1D intervals the distance must fall in the range of ['mindist',
'maxdist']. If 'intervals2' contains a 'strand' column the distance can be
positive or negative depending on the 'strand' value and the position of
interval2 relatively to interval1. If 'strand' column is missing the
distance is always positive.

For 2D intervals two distances are calculated and returned for each axis.
The distances must fall in the range of ['mindist1', 'maxdist1'] for axis 1
and ['mindist2', 'maxdist2'] for axis 2. For selecting the closest
'maxneighbors' intervals Manhattan distance is used (i.e. dist1+dist2).

The names of the returned columns are made unique using
\code{make.unique(colnames(df), sep = "")}, assuming 'df' is the result.

If 'intervals.set.out' is not 'NULL' the result is saved as an intervals
set. Use this parameter if the result size exceeds the limits of the
physical memory.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
intervs1 <- giterator.intervals("dense_track",
    gintervals(1, 0, 4000),
    iterator = 233
)
intervs2 <- giterator.intervals(
    "sparse_track",
    gintervals(1, 0, 2000)
)
gintervals.neighbors(intervs1, intervs2, 10,
    mindist = -300,
    maxdist = 500
)
intervs2$strand <- c(1, 1, -1, 1)
gintervals.neighbors(intervs1, intervs2, 10,
    mindist = -300,
    maxdist = 500
)

}
\seealso{
\code{\link{gintervals}},
}
\keyword{~annotate}
\keyword{~intervals}
\keyword{~nearest}
\keyword{~neighbor}
\keyword{~neighbors}
