% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numerical_deriv.R
\name{numerical_deriv}
\alias{numerical_deriv}
\title{Compute numerical derivatives}
\usage{
numerical_deriv(f, par, ..., delta = 1e-05, gradient = TRUE,
  type = "Richardson")
}
\arguments{
\item{f}{the objective function being evaluated}

\item{par}{a vector of parameters}

\item{...}{additional arguments to be passed to \code{f}}

\item{delta}{the term used to perturb the \code{f} function. Default is 1e-5}

\item{gradient}{logical; compute the gradient terms? If FALSE then the Hessian is computed instead}

\item{type}{type of difference to compute. Can be either \code{'forward'} for the forward difference,
\code{'central'} for the central difference, or \code{'Richardson'} for the Richardson extrapolation (default).
Backward difference is achieved by supplying a negative \code{delta} value with \code{'forward'}.
When \code{type = 'Richardson'}, the default value of \code{delta} is increased to \code{delta * 1000} for the
Hessian and \code{delta * 10} for the gradient to provide a reasonable perturbation starting
location (each \code{delta} is halved at each iteration).}
}
\description{
Compute numerical derivatives using forward/backward difference,
central difference, or Richardson extrapolation.
}
\examples{

\dontrun{
f <- function(x) 3*x[1]^3 - 4*x[2]^2
par <- c(3,8)

# grad = 9 * x^2 , -8 * y
(actual <- c(9 * par[1]^2, -8 * par[2]))
numerical_deriv(f, par, type = 'forward')
numerical_deriv(f, par, type = 'central')
numerical_deriv(f, par, type = 'Richardson') # default

# Hessian = h11 -> 18 * x, h22 -> -8, h12 -> h21 -> 0
(actual <- matrix(c(18 * par[1], 0, 0, -8), 2, 2))
numerical_deriv(f, par, type = 'forward', gradient = FALSE)
numerical_deriv(f, par, type = 'central', gradient = FALSE)
numerical_deriv(f, par, type = 'Richardson', gradient = FALSE) # default

}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{derivatives}
\keyword{numerical}
