% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeMissing.R
\name{imputeMissing}
\alias{imputeMissing}
\title{Imputing plausible data for missing values}
\usage{
imputeMissing(x, Theta, warn = TRUE, ...)
}
\arguments{
\item{x}{an estimated model x from the mirt package}

\item{Theta}{a matrix containing the estimates of the latent trait scores
(e.g., via \code{\link{fscores}})}

\item{warn}{logical; print warning messages?}

\item{...}{additional arguments to pass}
}
\description{
Given an estimated model from any of mirt's model fitting functions and an estimate of the
latent trait, impute plausible missing data values. Returns the original data in a
\code{data.frame} without any NA values. If a list of \code{Theta} values is supplied then a
list of complete datasets is returned instead.
}
\examples{
\dontrun{
dat <- expand.table(LSAT7)
(original <- mirt(dat, 1))
NAperson <- sample(1:nrow(dat), 20, replace = TRUE)
NAitem <- sample(1:ncol(dat), 20, replace = TRUE)
for(i in 1:20)
    dat[NAperson[i], NAitem[i]] <- NA
(mod <- mirt(dat, 1))
scores <- fscores(mod, method = 'MAP')

#re-estimate imputed dataset (good to do this multiple times and average over)
fulldata <- imputeMissing(mod, scores)
(fullmod <- mirt(fulldata, 1))

#with multipleGroup
set.seed(1)
group <- sample(c('group1', 'group2'), 1000, TRUE)
mod2 <- multipleGroup(dat, 1, group, TOL=1e-2)
fs <- fscores(mod2)
fulldata2 <- imputeMissing(mod2, fs)

}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{data}
\keyword{impute}
