% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDIFF.R
\name{MDIFF}
\alias{MDIFF}
\title{Compute multidimensional difficulty index}
\usage{
MDIFF(x, which.items = NULL)
}
\arguments{
\item{x}{an object of class 'SingleGroupClass'}

\item{which.items}{a vector indicating which items to select. If NULL is used
(the default) then MDISC will be computed for all items}
}
\description{
Returns a matrix containing the MDIFF values (Reckase, 2009). Only suppored for items of class
'dich' and 'graded'.
}
\examples{
\dontrun{

mod <- mirt(Science, 2)
MDIFF(mod)

mod <- mirt(expand.table(LSAT7), 2)
MDIFF(mod)

}
}
\references{
Reckase, M. D. (2009). Multidimensional Item Response Theory. Springer.
}
\seealso{
\code{\link{extract.group}}, \code{\link{MDISC}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{discrimination}
