% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_centrality.R
\name{close_centrality}
\alias{close_centrality}
\alias{node_closeness}
\alias{node_reach}
\alias{node_harmonic}
\alias{tie_closeness}
\alias{network_closeness}
\alias{network_reach}
\alias{network_harmonic}
\title{Measures of closeness-like centrality and centralisation}
\usage{
node_closeness(.data, normalized = TRUE, direction = "out", cutoff = NULL)

node_reach(.data, normalized = TRUE, k = 2)

node_harmonic(.data, normalized = TRUE, k = -1)

tie_closeness(.data, normalized = TRUE)

network_closeness(.data, normalized = TRUE, direction = c("all", "out", "in"))

network_reach(.data, normalized = TRUE, k = 2)

network_harmonic(.data, normalized = TRUE, k = 2)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{normalized}{Logical scalar, whether the centrality scores are normalized.
Different denominators are used depending on whether the object is one-mode or two-mode,
the type of centrality, and other arguments.}

\item{direction}{Character string, “out” bases the measure on outgoing ties,
“in” on incoming ties, and "all" on either/the sum of the two.
For two-mode networks, "all" uses as numerator the sum of differences
between the maximum centrality score for the mode
against all other centrality scores in the network,
whereas "in" uses as numerator the sum of differences
between the maximum centrality score for the mode
against only the centrality scores of the other nodes in that mode.}

\item{cutoff}{Maximum path length to use during calculations.}

\item{k}{Integer of steps out to calculate reach}
}
\description{
Measures of closeness-like centrality and centralisation
}
\section{Functions}{
\itemize{
\item \code{node_closeness()}: Calculate the closeness centrality of nodes in a network

\item \code{node_reach()}: Calculate nodes' reach centrality
or how many nodes they can reach within \emph{k} steps

\item \code{node_harmonic()}: Calculate nodes' harmonic centrality or valued centrality.
This is thought to behave better than reach centrality for disconnected networks.

\item \code{tie_closeness()}: Calculate the closeness of each edge to each other edge
in the network.

\item \code{network_closeness()}: Calculate a network's closeness centralization

\item \code{network_reach()}: Calculate a network's reach centralization

\item \code{network_harmonic()}: Calculate a network's harmonic centralization

}}
\examples{
node_closeness(mpn_elite_mex)
node_closeness(ison_southern_women)
node_reach(ison_adolescents)
(ec <- tie_closeness(ison_adolescents))
plot(ec)
#ison_adolescents \%>\% 
#   activate(edges) \%>\% mutate(weight = ec) \%>\% 
#   autographr()
network_closeness(ison_southern_women, direction = "in")
}
\references{
Marchiori, M, and V Latora. 2000.
"Harmony in the small-world".
\emph{Physica A} 285: 539-546.

Dekker, Anthony. 2005.
"Conceptual distance in social network analysis".
\emph{Journal of Social Structure} 6(3).
}
\seealso{
Other measures: 
\code{\link{between_centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}},
\code{\link{features}},
\code{\link{heterogeneity}},
\code{\link{hierarchy}},
\code{\link{holes}},
\code{\link{net_diffusion}},
\code{\link{node_diffusion}}

Other centrality: 
\code{\link{between_centrality}},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}}
}
\concept{centrality}
\concept{measures}
