% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_centrality.R
\name{between_centrality}
\alias{between_centrality}
\alias{node_betweenness}
\alias{tie_betweenness}
\alias{network_betweenness}
\title{Measures of betweenness-like centrality and centralisation}
\usage{
node_betweenness(.data, normalized = TRUE, cutoff = NULL)

tie_betweenness(.data, normalized = TRUE)

network_betweenness(
  .data,
  normalized = TRUE,
  direction = c("all", "out", "in")
)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{normalized}{Logical scalar, whether the centrality scores are normalized.
Different denominators are used depending on whether the object is one-mode or two-mode,
the type of centrality, and other arguments.}

\item{cutoff}{The maximum path length to consider when calculating betweenness.
If negative or NULL (the default), there's no limit to the path lengths considered.}

\item{direction}{Character string, “out” bases the measure on outgoing ties,
“in” on incoming ties, and "all" on either/the sum of the two.
For two-mode networks, "all" uses as numerator the sum of differences
between the maximum centrality score for the mode
against all other centrality scores in the network,
whereas "in" uses as numerator the sum of differences
between the maximum centrality score for the mode
against only the centrality scores of the other nodes in that mode.}
}
\value{
A numeric vector giving the betweenness centrality measure of each node.
}
\description{
Measures of betweenness-like centrality and centralisation
}
\section{Functions}{
\itemize{
\item \code{node_betweenness()}: Calculate the betweenness centralities of nodes in a network

\item \code{tie_betweenness()}: Calculate number of shortest paths going through a tie

\item \code{network_betweenness()}: Calculate the betweenness centralization for a network

}}
\examples{
node_betweenness(mpn_elite_mex)
node_betweenness(ison_southern_women)
(tb <- tie_betweenness(ison_adolescents))
plot(tb)
#ison_adolescents \%>\% mutate_ties(weight = tb) \%>\% 
#   autographr()
network_betweenness(ison_southern_women, direction = "in")
}
\seealso{
Other measures: 
\code{\link{close_centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}},
\code{\link{features}},
\code{\link{heterogeneity}},
\code{\link{hierarchy}},
\code{\link{holes}},
\code{\link{net_diffusion}},
\code{\link{node_diffusion}}

Other centrality: 
\code{\link{close_centrality}},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}}
}
\concept{centrality}
\concept{measures}
