% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockmodel_visualisation.R
\name{blockmodel_visualisation}
\alias{blockmodel_visualisation}
\alias{plot.blockmodel}
\alias{ggtree}
\alias{ggidentify_clusters}
\title{ggplot2-based plotting of blockmodel results}
\usage{
\method{plot}{blockmodel}(x, ...)

ggtree(hc, k = NULL)

ggidentify_clusters(hc, mat, method = "elbow")
}
\arguments{
\item{x}{A blockmodel-class object.}

\item{...}{Additional arguments passed on to ggplot2.}

\item{hc}{a hierarchical cluster object}

\item{k}{number of clusters. By default NULL,
but, if specified, \code{ggtree} will color branches and
add a line to indicate where the corresponding cluster
cut would be.}

\item{mat}{the matrix}

\item{method}{only "elbow" is currently implemented.}
}
\description{
ggplot2-based plotting of blockmodel results

Plots for deciding on the number of network clusters
}
\examples{
usa_concor <- blockmodel_concor(mpn_elite_usa_advice)
plot(usa_concor)
res <- cluster_regular_equivalence(mpn_elite_mex)
ggtree(res, 4)
ggidentify_clusters(res, t(node_triad_census(mpn_elite_mex)))
}
