% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_add.R
\name{add}
\alias{add}
\alias{add_node_attribute}
\alias{add_tie_attribute}
\alias{copy_node_attributes}
\alias{join_ties}
\title{Adding and copying attributes from one graph to another}
\usage{
add_node_attribute(object, attr_name, vector)

add_tie_attribute(object, attr_name, vector)

copy_node_attributes(object, object2)

join_ties(object, object2, attr_name)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{attr_name}{Name of the new attribute in the resulting object.}

\item{vector}{A vector of values for the new attribute.}

\item{object2}{A second object to copy nodes or edges from.}
}
\description{
These functions allow users to add attributes to a graph from another graph
or from a specified vector supplied by the user.
}
\section{Functions}{
\itemize{
\item \code{add_node_attribute()}: Insert specified values from a vector into the graph
as node attributes

\item \code{add_tie_attribute()}: Insert specified values from a vector into the graph
as tie attributes

\item \code{copy_node_attributes()}: Copies node attributes from a given graph into specified graph

\item \code{join_ties()}: Copies ties from another graph to specified graph and
adds a tie attribute identifying the ties that were newly added

}}
\examples{
add_node_attribute(mpn_elite_mex, "wealth", 1:35)
add_node_attribute(mpn_elite_usa_advice, "wealth", 1:14)
add_tie_attribute(ison_adolescents, "weight", c(1,2,1,1,1,3,2,2,3,1))
autographr(mpn_elite_mex)
both <- join_ties(mpn_elite_mex, generate_random(mpn_elite_mex), "random")
autographr(both)
random <- to_uniplex(both, "random")
autographr(random)
autographr(to_uniplex(both, "orig"))
}
\seealso{
Other manipulations: 
\code{\link{as}()},
\code{\link{grab}},
\code{\link{reformat}},
\code{\link{transform}()}
}
\concept{manipulations}
