% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mo.R
\name{rank_nondominated}
\alias{rank_nondominated}
\title{Perform Nondominated Sorting}
\usage{
rank_nondominated(fitnesses, epsilon = 0)
}
\arguments{
\item{fitnesses}{(\verb{numeric matrix})\cr
fitness matrix, with one row per individual and one column per objective}

\item{epsilon}{(\code{numeric})\cr
Epsilon-vaue for non-dominance. A value is epsilon-dominated by another if it is at least \code{epsilon} smaller than
the other in all dimensions, and more than \code{epsilon} smaller than the other in one dimension. \code{epsilon} may
be a scalar, in which case it is used for all dimensions or a vector, in which case its length must match
the number of dimensions. Default 0.}
}
\value{
\code{list}: \verb{$front}: Vector assigning each individual in \code{fitnesses} its nondominated front.
\verb{$domcount}: Length N vector counting the number of individuals that dominate the given individual.
}
\description{
Assign elements of \code{fitnesses} to nondominated fronts.

The first nondominated front is the set of individuals that is not dominated by any other
individual with respect to any fitness dimension, i.e. where no other individual exists that
has all fitness values greater or equal, with at least one fitness value strictly greater.

The n'th nondominated front is the set of individuals that is not dominated by any other
individual that is not in any nondominated front with smaller n.

Fitnesses are \emph{maximized}, so the individuals in lower numbered nondominated fronts tend
to have higher fitness values.
}
