% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TerminatorBudget.R
\name{mlr_terminators_budget}
\alias{mlr_terminators_budget}
\alias{TerminatorBudget}
\title{Terminator that Limits Total Budget Component Evaluation}
\description{
\code{\link[bbotk:Terminator]{Terminator}} that terminates after the sum (or similar aggregate) of a given "budget" search space component croses a threshold.
}
\section{Dictionary}{

This \code{\link[bbotk:Terminator]{Terminator}} can be created with the short access form \code{\link[bbotk:trm]{trm()}} (\code{\link[bbotk:trm]{trms()}} to get a list),
or through the \link[mlr3misc:Dictionary]{dictionary} \code{\link[bbotk:mlr_terminators]{mlr_terminators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred
trm("budget")
trms("budget")  # takes vector IDs, returns list of Terminators

# long form
mlr_terminators$get("budget")
}\if{html}{\out{</div>}}
}

\section{Configuration Parameters}{

\itemize{
\item \code{budget} :: \code{numeric(1)}\cr
Total budget available, after which to stop. Not initialized and should be set to the desired value during construction.
\item \code{aggregate} :: \code{function}\cr
Function taking a vector of values of the budget search space component, returning a scalar value to be compared
to the \code{budget} configuration parameter. If this function returns a value greater or equal to \code{budget} the termination
criterion is matched. Calling this function with \code{NULL} must return the lower bound of the budget value; percentage
progress is reported as the progress from this lower bound to the value of \code{budget}. Initialized to \code{sum()}.
}
}

\examples{
library("bbotk")
# Evaluate until sum of budget component of evaluated configs is >= 100
trm("budget", budget = 100)

# Evaluate until sum of two to the power of budget component is >= 100
trm("budget", budget = 1024, aggregate = function(x) sum(2 ^ x))
}
\section{Super class}{
\code{\link[bbotk:Terminator]{bbotk::Terminator}} -> \code{TerminatorBudget}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TerminatorBudget-new}{\code{TerminatorBudget$new()}}
\item \href{#method-TerminatorBudget-is_terminated}{\code{TerminatorBudget$is_terminated()}}
\item \href{#method-TerminatorBudget-clone}{\code{TerminatorBudget$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="format"><a href='../../bbotk/html/Terminator.html#method-Terminator-format'><code>bbotk::Terminator$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="print"><a href='../../bbotk/html/Terminator.html#method-Terminator-print'><code>bbotk::Terminator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="remaining_time"><a href='../../bbotk/html/Terminator.html#method-Terminator-remaining_time'><code>bbotk::Terminator$remaining_time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="status"><a href='../../bbotk/html/Terminator.html#method-Terminator-status'><code>bbotk::Terminator$status()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorBudget-new"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorBudget-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{TerminatorBudget} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorBudget$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorBudget-is_terminated"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorBudget-is_terminated}{}}}
\subsection{Method \code{is_terminated()}}{
Is \code{TRUE} if when the termination criterion is matched, \code{FALSE} otherwise.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorBudget$is_terminated(archive)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{archive}}{\code{\link[bbotk:Archive]{Archive}}
Archive to check.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{logical(1)}: Whether to terminate.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorBudget-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorBudget-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorBudget$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
