% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_sia.R
\name{process_sia}
\alias{process_sia}
\title{Process SIA variables from DataSUS}
\usage{
process_sia(
  data,
  information_system = "SIA-PA",
  nome_proced = TRUE,
  nome_ocupacao = TRUE,
  nome_equipe = TRUE,
  municipality_data = TRUE
)
}
\arguments{
\item{data}{\code{data.frame} created by \code{fetch_datasus()}.}

\item{information_system}{string. The abbreviation of the health information system. See \emph{Details}.}

\item{nome_proced}{optional logical. \code{TRUE} by default, add  \code{PA_PROCED_NOME} to the dataset. This setting will start to download a file from DataSUS to retrive the updates list of procesures (SIGTAB).}

\item{nome_ocupacao}{optional logical. \code{TRUE} by default, add  \code{OCUPACAO} name to the dataset.}

\item{nome_equipe}{optional logical. \code{TRUE} by default, add  \code{EQUIPE} name to the dataset.}

\item{municipality_data}{optional logical. \code{TRUE} by default, creates new variables in the dataset informing the full name and other details about the municipality of residence.}
}
\value{
a \code{data.frame} with the processed data.
}
\description{
\code{process_sia} processes SIA variables retrieved by \code{fetch_datasus()}.
}
\details{
This function processes SIA variables retrieved by \code{fetch_datasus()}, informing labels for categoric variables including NA values.

Currently, only "SIA-PA" is supported.
}
\examples{
process_sia(sia_pa_sample, nome_proced = FALSE)

}
