% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_mgwrsar.R
\name{summary_mgwrsar}
\alias{summary_mgwrsar}
\title{Print a summary of mgwrsar models}
\usage{
summary_mgwrsar(model)
}
\arguments{
\item{model}{a model of class mgwrsar}
}
\value{
a summary of mgwrsar models
}
\description{
Print a summary of mgwrsar models
}
\examples{
\donttest{
 library(mgwrsar)
 ## loading data example
 data(mydata)
 coords=as.matrix(mydata[,c("x","y")])
 ## Creating a spatial weight matrix (sparce dgCMatrix)
 ## of 4 nearest neighbors with 0 in diagonal
 W=kernel_matW(H=4,kernels='rectangle',coord_i=coords,NN=4,adaptive=TRUE,
 diagnull=TRUE,rowNorm=TRUE)
 mgwrsar_0_kc_kv<-MGWRSAR(formula = 'Y_mgwrsar_0_kc_kv~X1+X2+X3', data = mydata,
 coords=coords, fixed_vars='X2',kernels=c('gauss'),H=20, Model = 'MGWRSAR_0_kc_kv',
 control=list(SE=FALSE,adaptive=TRUE,W=W))
 summary_mgwrsar(mgwrsar_0_kc_kv)
}
}
\seealso{
MGWRSAR, bandwidths_mgwrsar, plot_mgwrsar, predict_mgwrsar, kernel_matW
}
