% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{general}
\alias{general}
\alias{general.default}
\alias{general.formula}
\title{General meta-features}
\usage{
general(...)

\method{general}{default}(x, y, features = "all", summary = c("mean", "sd"), ...)

\method{general}{formula}(formula, data, features = "all", summary = c("mean", "sd"), ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{features}{A list of features names or \code{"all"} to include all them.
The supported values are described in the details section. (Default: 
\code{"all"})}

\item{summary}{A list of summarization functions or empty for all values. See
\link{post.processing} method to more information. (Default: 
\code{c("mean", "sd")})}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class}
}
\value{
A list named by the requested meta-features.
}
\description{
General meta-features include general information related to the dataset. It
is also known as simple measures.
}
\details{
The following features are allowed for this method:
 \describe{
   \item{"attrToInst"}{Ratio of the number of attributes per the number of 
   instances, also known as dimensionality.}
   \item{"catToNum"}{Ratio of the number of categorical attributes per the 
   number of numeric attributes.}
   \item{"freqClass"}{Proportion of the classes values (multi-valued).}
   \item{"instToAttr"}{Ratio of the number of instances per the number of 
   attributes.}
   \item{"nrAttr"}{Number of attributes.}
   \item{"nrBin"}{Number of binary attributes.}
   \item{"nrCat"}{Number of categorical attributes.}
   \item{"nrClass"}{Number of classes.}
   \item{"nrInst"}{Number of instances.}
   \item{"nrNum"}{Number of numeric attributes.}
   \item{"numToCat"}{Ratio of the number of numeric attributes per the number
   of categorical attributes.}
 }
}
\examples{
## Extract all metafeatures
general(Species ~ ., iris)

## Extract some metafeatures
general(iris[1:100, 1:4], iris[1:100, 5], c("nrAttr", "nrClass"))

## Extract all meta-features without summarize prop.class
general(Species ~ ., iris, summary=c())

## Use another summarization functions
general(Species ~ ., iris, summary=c("sd","min","iqr"))
}
\references{
Donald Michie, David J. Spiegelhalter, Charles C. Taylor, and John Campbell.
 Machine Learning, Neural and Statistical Classification, volume 37. Ellis 
 Horwood Upper Saddle River, 1994.

 Guido Lindner and Rudi Studer. AST: Support for algorithm selection with a 
 CBR approach. In European Conference on Principles of Data Mining and 
 Knowledge Discovery (PKDD), pages 418 - 423, 1999.

 Ciro Castiello, Giovanna Castellano, and Anna M. Fanelli. Meta-data: 
 Characterization of input features for meta-learning. In 2nd International 
 Conference on Modeling Decisions for Artificial Intelligence (MDAI), 
 pages 457 - 468, 2005.
}
\seealso{
Other meta-features: 
\code{\link{clustering}()},
\code{\link{complexity}()},
\code{\link{concept}()},
\code{\link{infotheo}()},
\code{\link{itemset}()},
\code{\link{landmarking}()},
\code{\link{model.based}()},
\code{\link{relative}()},
\code{\link{statistical}()}
}
\concept{meta-features}
