% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{predict.mfbvar}
\alias{predict.mfbvar}
\title{Predict method for class \code{mfbvar}}
\usage{
\method{predict}{mfbvar}(object, aggregate_fcst = TRUE, pred_bands = 0.8, ...)
}
\arguments{
\item{object}{object of class mfbvar}

\item{aggregate_fcst}{If forecasts of quarterly variables should be aggregated back to the quarterly frequency.}

\item{pred_bands}{The level of the probability bands for the forecasts.}

\item{...}{Currently not in use.}
}
\description{
Method for predicting \code{mfbvar} objects.
}
\details{
Note that this requires that forecasts were made in the original \code{mfbvar} call.
}
\examples{
prior_obj <- set_prior(Y = mf_usa, n_lags = 4, n_reps = 20, n_fcst = 4)
mod_minn <- estimate_mfbvar(prior_obj, prior = "minn")
predict(mod_minn)
}
