% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Northrop_Coleman_Extremes_2014.R
\name{gp.fit}
\alias{gp.fit}
\title{Peaks-Over-Threshold Modelling using the Generalized Pareto Distribution}
\usage{
gp.fit(xdat, threshold, method = c("Grimshaw", "nlm", "optim", "ismev",
  "bayes"), show = TRUE)
}
\arguments{
\item{xdat}{a numeric vector of data to be fitted.}

\item{threshold}{The chosen threshold.}

\item{method}{The method to be used. See Details??. Can be abbreviated.}

\item{show}{Logical; if \code{TRUE} (the default), print details of the fit.}
}
\value{
If \code{method="bayes"}, a vector containing the posterior scale and shape parameters.
Otherwise, a list containing the following components:
\itemize{
\item \code{estimate} A vector containing all parameters (optimized and fixed).
\item \code{std.err} A vector containing the standard errors.
\item \code{var.cov} The variance covariance matrix, obtained as the numerical inverse of the observed information matrix.
\item \code{threshold} The threshold.
\item \code{method} The method used to fit the parameter. See details.
\item \code{deviance} The deviance at the maximum likelihood estimates.
\item \code{nat} Number of points lying above the threshold.
\item \code{pat} Proportion of points lying above the threshold.
\item \code{convergence} Components taken from the list returned by \code{\link[stats]{optim}}.
\item \code{counts} Components taken from the list returned by \code{\link[stats]{optim}}.
}
}
\description{
Numerical optimization of the Generalized Pareto distribution over a
high threshold.
}
\details{
The default method is \code{"Grimshaw"} using the reduction of the parameters to a one-dimensional
maximization suggested in Davison (1984). Other options are \code{\link[stats]{nlm}} function, which performs the maximization using the \code{nlm} function, and \code{"1D.optim"}
that uses \code{\link[stats]{optim}}. Two-dimensional optimisation using \code{"ismev"} using the routine
from \code{\link[ismev]{gpd.fit}} from the \code{\link[ismev]{ismev}} library, with the addition of the algebraic gradient.
}
\examples{
library(ismev)
data(rain)
threshold <- quantile(rain,0.9)
gp.fit(rain, threshold, method="Grimshaw")
}
\author{
Paul J. Northrop and Claire L. Coleman
}
\seealso{
\code{\link[evd]{fpot}} and \code{\link[ismev]{gpd.fit}}
}

