% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-pc-hazard.R
\name{sim.cox}
\alias{sim.cox}
\alias{sim.phreg}
\alias{read.phreg}
\alias{read.fit}
\alias{sim.base}
\alias{simulate.cox}
\alias{sim.phregs}
\alias{setup.phreg}
\title{Simulation of output from Cox model.}
\usage{
sim.cox(cox,n,data=NULL,cens=NULL,rrc=NULL,entry=NULL,rr=NULL,Z=NULL,extend=TRUE,...)
}
\arguments{
\item{cox}{output form coxph or cox.aalen model fitting cox model.}

\item{n}{number of simulations.}

\item{data}{to extract covariates for simulations (draws from observed
covariates).}

\item{cens}{specifies censoring model, if "is.matrix" then uses cumulative
hazard given, if "is.scalar" then uses rate for exponential, and if not
given then takes average rate of in simulated data from cox model.}

\item{rrc}{possible vector of relative risk for cox-type censoring.}

\item{entry}{delayed entry variable for simulation.}

\item{rr}{possible vector of relative risk for cox model.}

\item{Z}{possible covariates to use instead of sampling from data.}

\item{extend}{to extend possible stratified baselines to largest end-point}

\item{...}{arguments for rchaz, for example entry-time.}
}
\description{
Simulates data that looks like fit from Cox model. Censor data automatically
for highest value of the event times by using cumulative hazard.
}
\examples{
data(sTRACE)
nsim <- 100
coxs <-  phreg(Surv(time,status==9)~strata(chf)+vf+wmi,data=sTRACE)
sim3 <- sim.phreg(coxs,nsim,data=sTRACE)
cc <-   phreg(Surv(time, status)~strata(chf)+vf+wmi,data=sim3)
cbind(coxs$coef,cc$coef)
plot(coxs,col=1); plot(cc,add=TRUE,col=2)

}
\author{
Thomas Scheike
}
\keyword{survival}
