% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dutils.R
\name{drelevel}
\alias{dfactor}
\alias{dfactor<-}
\alias{dlevels}
\alias{dnumeric}
\alias{dnumeric<-}
\alias{drelevel}
\alias{drelevel<-}
\title{relev levels for data frames}
\usage{
drelevel(data, x, ref = NULL, regex = mets.options()$regex, sep = NULL,
  ...)
}
\arguments{
\item{data}{if x is formula or names for data frame then data frame is needed.}

\item{x}{name of variable, or fomula, or names of variables on data frame.}

\item{ref}{new reference variable}

\item{regex}{for regular expressions.}

\item{sep}{seperator for naming of cut names.}

\item{...}{Optional additional arguments}
}
\description{
levels shows levels for variables in data frame, relevel relevels a factor in data.frame
}
\examples{

data(mena)
dstr(mena)
dfactor(mena)  <- ~twinnum
dnumeric(mena) <- ~twinnum.f

dstr(mena)

mena2 <- drelevel(mena,"cohort","(1980,1982]")
mena2 <- drelevel(mena,~cohort,"(1980,1982]")
dlevels(mena)
dlevels(mena2)
drelevel(mena,ref="(1975,1977]")  <-  ~cohort
drelevel(mena,ref="(1980,1982]")  <-  ~cohort
dlevels(mena,"coh*")
dtable(mena,"coh*",level=1)

### level 1 of zyg as baseline for new variable
drelevel(mena,ref=1) <- ~zyg
drelevel(mena,ref=c("DZ","[1973,1975]")) <- ~ zyg+cohort
### level 2 of zyg and cohort as baseline for new variables
drelevel(mena,ref=2) <- ~ zyg+cohort
dlevels(mena)

}
\author{
Klaus K. Holst and Thomas Scheike
}

