% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_deltap.R
\name{deltap}
\alias{deltap}
\alias{mk}
\title{deltaP or Markedness}
\usage{
deltap(
  data = NULL,
  obs,
  pred,
  pos_level = 2,
  atom = FALSE,
  tidy = FALSE,
  na.rm = TRUE
)

mk(
  data = NULL,
  obs,
  pred,
  pos_level = 2,
  atom = FALSE,
  tidy = FALSE,
  na.rm = TRUE
)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (character | factor).}

\item{pred}{Vector with predicted values (character | factor).}

\item{pos_level}{Integer, for binary cases, indicating the order (1|2) of the level
corresponding to the positive. Generally, the positive level is the second (2)
since following an alpha-numeric order, the most common pairs are
\code{(Negative | Positive)}, \code{(0 | 1)}, \code{(FALSE | TRUE)}. Default : 2.}

\item{atom}{Logical operator (TRUE/FALSE) to decide if the estimate is made for
each class (atom = TRUE) or at a global level (atom = FALSE); Default : FALSE.
When dataset is "binomial" atom does not apply.}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
\code{deltap} estimates the Markedness or deltaP for a nominal/categorical
predicted-observed dataset.

\code{mk} estimates the Markedness (equivalent
to deltaP) for a nominal/categorical predicted-observed dataset.
}
\details{
The \code{deltap} is also known as the markedness. It is a metric
that quantifies the probability that a condition is marked by the predictor with
respect to a random chance (Powers, 2011).

The deltap is related to \code{precision} (or positive predictive values -ppv-)
and its inverse (the negative predictive value -\code{npv}-) as follows:

\eqn{deltap = PPV + NPV - 1  = precision + npv - 1}

The higher the deltap the better the classification performance.

For the formula and more details, see
\href{https://adriancorrendo.github.io/metrica/articles/available_metrics_classification.html}{online-documentation}
}
\examples{
\donttest{
set.seed(123)
# Two-class
binomial_case <- data.frame(labels = sample(c("True","False"), 100, replace = TRUE), 
predictions = sample(c("True","False"), 100, replace = TRUE))
# Get deltap estimate for two-class case
deltap(data = binomial_case, obs = labels, pred = predictions)

}
}
\references{
Powers, D.M.W. (2011).
Evaluation: From Precision, Recall and F-Measure to ROC, Informedness, Markedness & Correlation.
\emph{Journal of Machine Learning Technologies 2(1): 37–63.} \doi{10.48550/arXiv.2010.16061}
}
